@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.kotlin.outputs.UserHierarchyGroupHierarchyPath
import com.pulumi.aws.connect.kotlin.outputs.UserHierarchyGroupHierarchyPath.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [UserHierarchyGroup].
 */
@PulumiTagMarker
public class UserHierarchyGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserHierarchyGroupArgs = UserHierarchyGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserHierarchyGroupArgsBuilder.() -> Unit) {
        val builder = UserHierarchyGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): UserHierarchyGroup {
        val builtJavaResource = com.pulumi.aws.connect.UserHierarchyGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserHierarchyGroup(builtJavaResource)
    }
}

/**
 * Provides an Amazon Connect User Hierarchy Group resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * > **NOTE:** The User Hierarchy Structure must be created before creating a User Hierarchy Group.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.UserHierarchyGroup;
 * import com.pulumi.aws.connect.UserHierarchyGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserHierarchyGroup("example", UserHierarchyGroupArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .tags(Map.of("Name", "Example User Hierarchy Group"))
 *             .build());
 *     }
 * }
 * ```
 * ### With a parent group
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.UserHierarchyGroup;
 * import com.pulumi.aws.connect.UserHierarchyGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var parent = new UserHierarchyGroup("parent", UserHierarchyGroupArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .tags(Map.of("Name", "Example User Hierarchy Group Parent"))
 *             .build());
 *         var child = new UserHierarchyGroup("child", UserHierarchyGroupArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .parentGroupId(parent.hierarchyGroupId())
 *             .tags(Map.of("Name", "Example User Hierarchy Group Child"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon Connect User Hierarchy Groups using the `instance_id` and `hierarchy_group_id` separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:connect/userHierarchyGroup:UserHierarchyGroup example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 *
 */
public class UserHierarchyGroup internal constructor(
    override val javaResource: com.pulumi.aws.connect.UserHierarchyGroup,
) : KotlinCustomResource(javaResource, UserHierarchyGroupMapper) {
    /**
     * The Amazon Resource Name (ARN) of the hierarchy group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The identifier for the hierarchy group.
     */
    public val hierarchyGroupId: Output<String>
        get() = javaResource.hierarchyGroupId().applyValue({ args0 -> args0 })

    /**
     * A block that contains information about the levels in the hierarchy group. The `hierarchy_path` block is documented below.
     */
    public val hierarchyPaths: Output<List<UserHierarchyGroupHierarchyPath>>
        get() = javaResource.hierarchyPaths().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * Specifies the identifier of the hosting Amazon Connect Instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The identifier of the level in the hierarchy group.
     */
    public val levelId: Output<String>
        get() = javaResource.levelId().applyValue({ args0 -> args0 })

    /**
     * The name of the user hierarchy group. Must not be more than 100 characters.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The identifier for the parent hierarchy group. The user hierarchy is created at level one if the parent group ID is null.
     */
    public val parentGroupId: Output<String>?
        get() = javaResource.parentGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Tags to apply to the hierarchy group. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object UserHierarchyGroupMapper : ResourceMapper<UserHierarchyGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.connect.UserHierarchyGroup::class == javaResource::class

    override fun map(javaResource: Resource): UserHierarchyGroup = UserHierarchyGroup(
        javaResource as
            com.pulumi.aws.connect.UserHierarchyGroup,
    )
}

/**
 * @see [UserHierarchyGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserHierarchyGroup].
 */
public suspend fun userHierarchyGroup(
    name: String,
    block: suspend UserHierarchyGroupResourceBuilder.() -> Unit,
): UserHierarchyGroup {
    val builder = UserHierarchyGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserHierarchyGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userHierarchyGroup(name: String): UserHierarchyGroup {
    val builder = UserHierarchyGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
