@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.UserHierarchyGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Connect User Hierarchy Group resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * > **NOTE:** The User Hierarchy Structure must be created before creating a User Hierarchy Group.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.UserHierarchyGroup;
 * import com.pulumi.aws.connect.UserHierarchyGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserHierarchyGroup("example", UserHierarchyGroupArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .tags(Map.of("Name", "Example User Hierarchy Group"))
 *             .build());
 *     }
 * }
 * ```
 * ### With a parent group
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.UserHierarchyGroup;
 * import com.pulumi.aws.connect.UserHierarchyGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var parent = new UserHierarchyGroup("parent", UserHierarchyGroupArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .tags(Map.of("Name", "Example User Hierarchy Group Parent"))
 *             .build());
 *         var child = new UserHierarchyGroup("child", UserHierarchyGroupArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .parentGroupId(parent.hierarchyGroupId())
 *             .tags(Map.of("Name", "Example User Hierarchy Group Child"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon Connect User Hierarchy Groups using the `instance_id` and `hierarchy_group_id` separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:connect/userHierarchyGroup:UserHierarchyGroup example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 * @property instanceId Specifies the identifier of the hosting Amazon Connect Instance.
 * @property name The name of the user hierarchy group. Must not be more than 100 characters.
 * @property parentGroupId The identifier for the parent hierarchy group. The user hierarchy is created at level one if the parent group ID is null.
 * @property tags Tags to apply to the hierarchy group. If configured with a provider
 * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class UserHierarchyGroupArgs(
    public val instanceId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val parentGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.UserHierarchyGroupArgs> {
    override fun toJava(): com.pulumi.aws.connect.UserHierarchyGroupArgs =
        com.pulumi.aws.connect.UserHierarchyGroupArgs.builder()
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parentGroupId(parentGroupId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [UserHierarchyGroupArgs].
 */
@PulumiTagMarker
public class UserHierarchyGroupArgsBuilder internal constructor() {
    private var instanceId: Output<String>? = null

    private var name: Output<String>? = null

    private var parentGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("kgbscjsfmsprmfaa")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The name of the user hierarchy group. Must not be more than 100 characters.
     */
    @JvmName("srntqryvwqfihguv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The identifier for the parent hierarchy group. The user hierarchy is created at level one if the parent group ID is null.
     */
    @JvmName("mbpkejbwbeftyuea")
    public suspend fun parentGroupId(`value`: Output<String>) {
        this.parentGroupId = value
    }

    /**
     * @param value Tags to apply to the hierarchy group. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ilwrqldrkrokcryd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("vruthsrgriqjykfv")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The name of the user hierarchy group. Must not be more than 100 characters.
     */
    @JvmName("gpvyxlbiwgmmfiby")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The identifier for the parent hierarchy group. The user hierarchy is created at level one if the parent group ID is null.
     */
    @JvmName("kayfnrbhlqavdjee")
    public suspend fun parentGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentGroupId = mapped
    }

    /**
     * @param value Tags to apply to the hierarchy group. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lxvekrfseefbjrtn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the hierarchy group. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hmhdwwwcmyalcjrp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): UserHierarchyGroupArgs = UserHierarchyGroupArgs(
        instanceId = instanceId,
        name = name,
        parentGroupId = parentGroupId,
        tags = tags,
    )
}
