@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.kotlin.outputs.UserHierarchyStructureHierarchyStructure
import com.pulumi.aws.connect.kotlin.outputs.UserHierarchyStructureHierarchyStructure.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UserHierarchyStructure].
 */
@PulumiTagMarker
public class UserHierarchyStructureResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserHierarchyStructureArgs = UserHierarchyStructureArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserHierarchyStructureArgsBuilder.() -> Unit) {
        val builder = UserHierarchyStructureArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): UserHierarchyStructure {
        val builtJavaResource = com.pulumi.aws.connect.UserHierarchyStructure(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserHierarchyStructure(builtJavaResource)
    }
}

/**
 * Provides an Amazon Connect User Hierarchy Structure resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.UserHierarchyStructure;
 * import com.pulumi.aws.connect.UserHierarchyStructureArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelOneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserHierarchyStructure("example", UserHierarchyStructureArgs.builder()
 *             .hierarchyStructure(UserHierarchyStructureHierarchyStructureArgs.builder()
 *                 .levelOne(UserHierarchyStructureHierarchyStructureLevelOneArgs.builder()
 *                     .name("levelone")
 *                     .build())
 *                 .build())
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .build());
 *     }
 * }
 * ```
 * ### With Five Levels
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.UserHierarchyStructure;
 * import com.pulumi.aws.connect.UserHierarchyStructureArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelFiveArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelFourArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelOneArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelThreeArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelTwoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserHierarchyStructure("example", UserHierarchyStructureArgs.builder()
 *             .hierarchyStructure(UserHierarchyStructureHierarchyStructureArgs.builder()
 *                 .levelFive(UserHierarchyStructureHierarchyStructureLevelFiveArgs.builder()
 *                     .name("levelfive")
 *                     .build())
 *                 .levelFour(UserHierarchyStructureHierarchyStructureLevelFourArgs.builder()
 *                     .name("levelfour")
 *                     .build())
 *                 .levelOne(UserHierarchyStructureHierarchyStructureLevelOneArgs.builder()
 *                     .name("levelone")
 *                     .build())
 *                 .levelThree(UserHierarchyStructureHierarchyStructureLevelThreeArgs.builder()
 *                     .name("levelthree")
 *                     .build())
 *                 .levelTwo(UserHierarchyStructureHierarchyStructureLevelTwoArgs.builder()
 *                     .name("leveltwo")
 *                     .build())
 *                 .build())
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon Connect User Hierarchy Structures using the `instance_id`. For example:
 * ```sh
 *  $ pulumi import aws:connect/userHierarchyStructure:UserHierarchyStructure example f1288a1f-6193-445a-b47e-af739b2
 * ```
 *
 */
public class UserHierarchyStructure internal constructor(
    override val javaResource: com.pulumi.aws.connect.UserHierarchyStructure,
) : KotlinCustomResource(javaResource, UserHierarchyStructureMapper) {
    /**
     * A block that defines the hierarchy structure's levels. The `hierarchy_structure` block is documented below.
     */
    public val hierarchyStructure: Output<UserHierarchyStructureHierarchyStructure>
        get() = javaResource.hierarchyStructure().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Specifies the identifier of the hosting Amazon Connect Instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })
}

public object UserHierarchyStructureMapper : ResourceMapper<UserHierarchyStructure> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.connect.UserHierarchyStructure::class == javaResource::class

    override fun map(javaResource: Resource): UserHierarchyStructure =
        UserHierarchyStructure(javaResource as com.pulumi.aws.connect.UserHierarchyStructure)
}

/**
 * @see [UserHierarchyStructure].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserHierarchyStructure].
 */
public suspend fun userHierarchyStructure(
    name: String,
    block: suspend UserHierarchyStructureResourceBuilder.() -> Unit,
): UserHierarchyStructure {
    val builder = UserHierarchyStructureResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserHierarchyStructure].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userHierarchyStructure(name: String): UserHierarchyStructure {
    val builder = UserHierarchyStructureResourceBuilder()
    builder.name(name)
    return builder.build()
}
