@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.UserHierarchyStructureArgs.builder
import com.pulumi.aws.connect.kotlin.inputs.UserHierarchyStructureHierarchyStructureArgs
import com.pulumi.aws.connect.kotlin.inputs.UserHierarchyStructureHierarchyStructureArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Connect User Hierarchy Structure resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.UserHierarchyStructure;
 * import com.pulumi.aws.connect.UserHierarchyStructureArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelOneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserHierarchyStructure("example", UserHierarchyStructureArgs.builder()
 *             .hierarchyStructure(UserHierarchyStructureHierarchyStructureArgs.builder()
 *                 .levelOne(UserHierarchyStructureHierarchyStructureLevelOneArgs.builder()
 *                     .name("levelone")
 *                     .build())
 *                 .build())
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .build());
 *     }
 * }
 * ```
 * ### With Five Levels
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.UserHierarchyStructure;
 * import com.pulumi.aws.connect.UserHierarchyStructureArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelFiveArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelFourArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelOneArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelThreeArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelTwoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserHierarchyStructure("example", UserHierarchyStructureArgs.builder()
 *             .hierarchyStructure(UserHierarchyStructureHierarchyStructureArgs.builder()
 *                 .levelFive(UserHierarchyStructureHierarchyStructureLevelFiveArgs.builder()
 *                     .name("levelfive")
 *                     .build())
 *                 .levelFour(UserHierarchyStructureHierarchyStructureLevelFourArgs.builder()
 *                     .name("levelfour")
 *                     .build())
 *                 .levelOne(UserHierarchyStructureHierarchyStructureLevelOneArgs.builder()
 *                     .name("levelone")
 *                     .build())
 *                 .levelThree(UserHierarchyStructureHierarchyStructureLevelThreeArgs.builder()
 *                     .name("levelthree")
 *                     .build())
 *                 .levelTwo(UserHierarchyStructureHierarchyStructureLevelTwoArgs.builder()
 *                     .name("leveltwo")
 *                     .build())
 *                 .build())
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon Connect User Hierarchy Structures using the `instance_id`. For example:
 * ```sh
 *  $ pulumi import aws:connect/userHierarchyStructure:UserHierarchyStructure example f1288a1f-6193-445a-b47e-af739b2
 * ```
 * @property hierarchyStructure A block that defines the hierarchy structure's levels. The `hierarchy_structure` block is documented below.
 * @property instanceId Specifies the identifier of the hosting Amazon Connect Instance.
 */
public data class UserHierarchyStructureArgs(
    public val hierarchyStructure: Output<UserHierarchyStructureHierarchyStructureArgs>? = null,
    public val instanceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.UserHierarchyStructureArgs> {
    override fun toJava(): com.pulumi.aws.connect.UserHierarchyStructureArgs =
        com.pulumi.aws.connect.UserHierarchyStructureArgs.builder()
            .hierarchyStructure(
                hierarchyStructure?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .instanceId(instanceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserHierarchyStructureArgs].
 */
@PulumiTagMarker
public class UserHierarchyStructureArgsBuilder internal constructor() {
    private var hierarchyStructure: Output<UserHierarchyStructureHierarchyStructureArgs>? = null

    private var instanceId: Output<String>? = null

    /**
     * @param value A block that defines the hierarchy structure's levels. The `hierarchy_structure` block is documented below.
     */
    @JvmName("mcebjpfwqlgesbpl")
    public suspend
    fun hierarchyStructure(`value`: Output<UserHierarchyStructureHierarchyStructureArgs>) {
        this.hierarchyStructure = value
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("njfedcmllkoomutm")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value A block that defines the hierarchy structure's levels. The `hierarchy_structure` block is documented below.
     */
    @JvmName("glvlexxoafpmecrk")
    public suspend fun hierarchyStructure(`value`: UserHierarchyStructureHierarchyStructureArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hierarchyStructure = mapped
    }

    /**
     * @param argument A block that defines the hierarchy structure's levels. The `hierarchy_structure` block is documented below.
     */
    @JvmName("hheftssoeqpxshcs")
    public suspend
    fun hierarchyStructure(argument: suspend UserHierarchyStructureHierarchyStructureArgsBuilder.() -> Unit) {
        val toBeMapped = UserHierarchyStructureHierarchyStructureArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.hierarchyStructure = mapped
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("clfdcoffidclhygf")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    internal fun build(): UserHierarchyStructureArgs = UserHierarchyStructureArgs(
        hierarchyStructure = hierarchyStructure,
        instanceId = instanceId,
    )
}
