@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.GetBotAssociationLexBot.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property lexRegion Region that the Amazon Lex (V1) bot was created in.
 * @property name Name of the Amazon Lex (V1) bot.
 */
public data class GetBotAssociationLexBot(
    public val lexRegion: String,
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.GetBotAssociationLexBot> {
    override fun toJava(): com.pulumi.aws.connect.inputs.GetBotAssociationLexBot =
        com.pulumi.aws.connect.inputs.GetBotAssociationLexBot.builder()
            .lexRegion(lexRegion.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBotAssociationLexBot].
 */
@PulumiTagMarker
public class GetBotAssociationLexBotBuilder internal constructor() {
    private var lexRegion: String? = null

    private var name: String? = null

    /**
     * @param value Region that the Amazon Lex (V1) bot was created in.
     */
    @JvmName("ucmllpfswbomslsy")
    public suspend fun lexRegion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.lexRegion = mapped
    }

    /**
     * @param value Name of the Amazon Lex (V1) bot.
     */
    @JvmName("qmijsrgfgjhjigfe")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetBotAssociationLexBot = GetBotAssociationLexBot(
        lexRegion = lexRegion ?: throw PulumiNullFieldException("lexRegion"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
