@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.GetContactFlowModulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getContactFlowModule.
 * @property contactFlowModuleId Returns information on a specific Contact Flow Module by contact flow module id
 * @property instanceId Reference to the hosting Amazon Connect Instance
 * @property name Returns information on a specific Contact Flow Module by name
 * @property tags Map of tags to assign to the Contact Flow Module.
 */
public data class GetContactFlowModulePlainArgs(
    public val contactFlowModuleId: String? = null,
    public val instanceId: String,
    public val name: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.GetContactFlowModulePlainArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.GetContactFlowModulePlainArgs =
        com.pulumi.aws.connect.inputs.GetContactFlowModulePlainArgs.builder()
            .contactFlowModuleId(contactFlowModuleId?.let({ args0 -> args0 }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetContactFlowModulePlainArgs].
 */
@PulumiTagMarker
public class GetContactFlowModulePlainArgsBuilder internal constructor() {
    private var contactFlowModuleId: String? = null

    private var instanceId: String? = null

    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Returns information on a specific Contact Flow Module by contact flow module id
     */
    @JvmName("dvrfkmlootiaygde")
    public suspend fun contactFlowModuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.contactFlowModuleId = mapped
    }

    /**
     * @param value Reference to the hosting Amazon Connect Instance
     */
    @JvmName("isclpkmauqslylqc")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value Returns information on a specific Contact Flow Module by name
     */
    @JvmName("vsocruconwcmguja")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Map of tags to assign to the Contact Flow Module.
     */
    @JvmName("prfawxkkmltdaqoe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the Contact Flow Module.
     */
    @JvmName("abcorgdnxtwptrrt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetContactFlowModulePlainArgs = GetContactFlowModulePlainArgs(
        contactFlowModuleId = contactFlowModuleId,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        name = name,
        tags = tags,
    )
}
