@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.GetContactFlowPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getContactFlow.
 * @property contactFlowId Returns information on a specific Contact Flow by contact flow id
 * @property instanceId Reference to the hosting Amazon Connect Instance
 * @property name Returns information on a specific Contact Flow by name
 * @property tags Tags to assign to the Contact Flow.
 * @property type Type of Contact Flow.
 */
public data class GetContactFlowPlainArgs(
    public val contactFlowId: String? = null,
    public val instanceId: String,
    public val name: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.GetContactFlowPlainArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.GetContactFlowPlainArgs =
        com.pulumi.aws.connect.inputs.GetContactFlowPlainArgs.builder()
            .contactFlowId(contactFlowId?.let({ args0 -> args0 }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetContactFlowPlainArgs].
 */
@PulumiTagMarker
public class GetContactFlowPlainArgsBuilder internal constructor() {
    private var contactFlowId: String? = null

    private var instanceId: String? = null

    private var name: String? = null

    private var tags: Map<String, String>? = null

    private var type: String? = null

    /**
     * @param value Returns information on a specific Contact Flow by contact flow id
     */
    @JvmName("amyfrcjqlwxipmya")
    public suspend fun contactFlowId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.contactFlowId = mapped
    }

    /**
     * @param value Reference to the hosting Amazon Connect Instance
     */
    @JvmName("grgnjvqkkwnrcmua")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value Returns information on a specific Contact Flow by name
     */
    @JvmName("ymihwcrsvrpfvjpb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Tags to assign to the Contact Flow.
     */
    @JvmName("qkgkjpgdimbsjdxp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Tags to assign to the Contact Flow.
     */
    @JvmName("tgeljgmcrmklnxsj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Type of Contact Flow.
     */
    @JvmName("pwlgilkoenkscsmp")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetContactFlowPlainArgs = GetContactFlowPlainArgs(
        contactFlowId = contactFlowId,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        name = name,
        tags = tags,
        type = type,
    )
}
