@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.GetHoursOfOperationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHoursOfOperation.
 * @property hoursOfOperationId Returns information on a specific Hours of Operation by hours of operation id
 * @property instanceId Reference to the hosting Amazon Connect Instance
 * @property name Returns information on a specific Hours of Operation by name
 * @property tags Map of tags to assign to the Hours of Operation.
 */
public data class GetHoursOfOperationPlainArgs(
    public val hoursOfOperationId: String? = null,
    public val instanceId: String,
    public val name: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.GetHoursOfOperationPlainArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.GetHoursOfOperationPlainArgs =
        com.pulumi.aws.connect.inputs.GetHoursOfOperationPlainArgs.builder()
            .hoursOfOperationId(hoursOfOperationId?.let({ args0 -> args0 }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetHoursOfOperationPlainArgs].
 */
@PulumiTagMarker
public class GetHoursOfOperationPlainArgsBuilder internal constructor() {
    private var hoursOfOperationId: String? = null

    private var instanceId: String? = null

    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Returns information on a specific Hours of Operation by hours of operation id
     */
    @JvmName("lwqswkwcljlbaucc")
    public suspend fun hoursOfOperationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hoursOfOperationId = mapped
    }

    /**
     * @param value Reference to the hosting Amazon Connect Instance
     */
    @JvmName("rfpusuqkbuhkhbjp")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value Returns information on a specific Hours of Operation by name
     */
    @JvmName("qyveogknemihuttv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Map of tags to assign to the Hours of Operation.
     */
    @JvmName("mewvgdhpraayjejy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the Hours of Operation.
     */
    @JvmName("bsyixvoboefksdql")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetHoursOfOperationPlainArgs = GetHoursOfOperationPlainArgs(
        hoursOfOperationId = hoursOfOperationId,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        name = name,
        tags = tags,
    )
}
