@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.GetInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstance.
 * @property instanceAlias Returns information on a specific connect instance by alias
 * @property instanceId Returns information on a specific connect instance by id
 */
public data class GetInstancePlainArgs(
    public val instanceAlias: String? = null,
    public val instanceId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.GetInstancePlainArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.GetInstancePlainArgs =
        com.pulumi.aws.connect.inputs.GetInstancePlainArgs.builder()
            .instanceAlias(instanceAlias?.let({ args0 -> args0 }))
            .instanceId(instanceId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstancePlainArgs].
 */
@PulumiTagMarker
public class GetInstancePlainArgsBuilder internal constructor() {
    private var instanceAlias: String? = null

    private var instanceId: String? = null

    /**
     * @param value Returns information on a specific connect instance by alias
     */
    @JvmName("aiyknidjciwrcvpm")
    public suspend fun instanceAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceAlias = mapped
    }

    /**
     * @param value Returns information on a specific connect instance by id
     */
    @JvmName("kycpkjpjqbgrotpq")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    internal fun build(): GetInstancePlainArgs = GetInstancePlainArgs(
        instanceAlias = instanceAlias,
        instanceId = instanceId,
    )
}
