@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.GetInstanceStorageConfigPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstanceStorageConfig.
 * @property associationId The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.
 * @property instanceId Reference to the hosting Amazon Connect Instance
 * @property resourceType A valid resource type. Valid Values: `AGENT_EVENTS` | `ATTACHMENTS` | `CALL_RECORDINGS` | `CHAT_TRANSCRIPTS` | `CONTACT_EVALUATIONS` | `CONTACT_TRACE_RECORDS` | `MEDIA_STREAMS` | `REAL_TIME_CONTACT_ANALYSIS_SEGMENTS` | `SCHEDULED_REPORTS` |  `SCREEN_RECORDINGS`.
 */
public data class GetInstanceStorageConfigPlainArgs(
    public val associationId: String,
    public val instanceId: String,
    public val resourceType: String,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.GetInstanceStorageConfigPlainArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.GetInstanceStorageConfigPlainArgs =
        com.pulumi.aws.connect.inputs.GetInstanceStorageConfigPlainArgs.builder()
            .associationId(associationId.let({ args0 -> args0 }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .resourceType(resourceType.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstanceStorageConfigPlainArgs].
 */
@PulumiTagMarker
public class GetInstanceStorageConfigPlainArgsBuilder internal constructor() {
    private var associationId: String? = null

    private var instanceId: String? = null

    private var resourceType: String? = null

    /**
     * @param value The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.
     */
    @JvmName("bojkvyjqvqbtutso")
    public suspend fun associationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.associationId = mapped
    }

    /**
     * @param value Reference to the hosting Amazon Connect Instance
     */
    @JvmName("gkdhflfcnrcyqlxi")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A valid resource type. Valid Values: `AGENT_EVENTS` | `ATTACHMENTS` | `CALL_RECORDINGS` | `CHAT_TRANSCRIPTS` | `CONTACT_EVALUATIONS` | `CONTACT_TRACE_RECORDS` | `MEDIA_STREAMS` | `REAL_TIME_CONTACT_ANALYSIS_SEGMENTS` | `SCHEDULED_REPORTS` |  `SCREEN_RECORDINGS`.
     */
    @JvmName("ujdlqluvlsxkyofj")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceType = mapped
    }

    internal fun build(): GetInstanceStorageConfigPlainArgs = GetInstanceStorageConfigPlainArgs(
        associationId = associationId ?: throw PulumiNullFieldException("associationId"),
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
    )
}
