@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.GetQuickConnectPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getQuickConnect.
 * @property instanceId Reference to the hosting Amazon Connect Instance
 * @property name Returns information on a specific Quick Connect by name
 * @property quickConnectId Returns information on a specific Quick Connect by Quick Connect id
 * @property tags Map of tags to assign to the Quick Connect.
 */
public data class GetQuickConnectPlainArgs(
    public val instanceId: String,
    public val name: String? = null,
    public val quickConnectId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.GetQuickConnectPlainArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.GetQuickConnectPlainArgs =
        com.pulumi.aws.connect.inputs.GetQuickConnectPlainArgs.builder()
            .instanceId(instanceId.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .quickConnectId(quickConnectId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetQuickConnectPlainArgs].
 */
@PulumiTagMarker
public class GetQuickConnectPlainArgsBuilder internal constructor() {
    private var instanceId: String? = null

    private var name: String? = null

    private var quickConnectId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Reference to the hosting Amazon Connect Instance
     */
    @JvmName("nqymqmolfbwbbrnu")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value Returns information on a specific Quick Connect by name
     */
    @JvmName("vpqnhixnidkfwqxe")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Returns information on a specific Quick Connect by Quick Connect id
     */
    @JvmName("qnkcbsnawstsjkrf")
    public suspend fun quickConnectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.quickConnectId = mapped
    }

    /**
     * @param value Map of tags to assign to the Quick Connect.
     */
    @JvmName("qvruhhcflcsudnco")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the Quick Connect.
     */
    @JvmName("yuuokxwccbhvkuug")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetQuickConnectPlainArgs = GetQuickConnectPlainArgs(
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        name = name,
        quickConnectId = quickConnectId,
        tags = tags,
    )
}
