@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.GetRoutingProfilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRoutingProfile.
 * @property instanceId Reference to the hosting Amazon Connect Instance
 * @property name Returns information on a specific Routing Profile by name
 * @property routingProfileId Returns information on a specific Routing Profile by Routing Profile id
 * @property tags Map of tags to assign to the Routing Profile.
 */
public data class GetRoutingProfilePlainArgs(
    public val instanceId: String,
    public val name: String? = null,
    public val routingProfileId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.GetRoutingProfilePlainArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.GetRoutingProfilePlainArgs =
        com.pulumi.aws.connect.inputs.GetRoutingProfilePlainArgs.builder()
            .instanceId(instanceId.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .routingProfileId(routingProfileId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetRoutingProfilePlainArgs].
 */
@PulumiTagMarker
public class GetRoutingProfilePlainArgsBuilder internal constructor() {
    private var instanceId: String? = null

    private var name: String? = null

    private var routingProfileId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Reference to the hosting Amazon Connect Instance
     */
    @JvmName("mjoeffnobkncvpdu")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value Returns information on a specific Routing Profile by name
     */
    @JvmName("vfyyavqfmgoepiok")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Returns information on a specific Routing Profile by Routing Profile id
     */
    @JvmName("xxuplrvepbmkoknw")
    public suspend fun routingProfileId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.routingProfileId = mapped
    }

    /**
     * @param value Map of tags to assign to the Routing Profile.
     */
    @JvmName("ilbmmrhbdslwovrn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the Routing Profile.
     */
    @JvmName("myprhmhdtadnxlmt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetRoutingProfilePlainArgs = GetRoutingProfilePlainArgs(
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        name = name,
        routingProfileId = routingProfileId,
        tags = tags,
    )
}
