@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.GetSecurityProfilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSecurityProfile.
 * @property instanceId Reference to the hosting Amazon Connect Instance
 * @property name Returns information on a specific Security Profile by name
 * @property securityProfileId Returns information on a specific Security Profile by Security Profile id
 * @property tags Map of tags to assign to the Security Profile.
 */
public data class GetSecurityProfilePlainArgs(
    public val instanceId: String,
    public val name: String? = null,
    public val securityProfileId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.GetSecurityProfilePlainArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.GetSecurityProfilePlainArgs =
        com.pulumi.aws.connect.inputs.GetSecurityProfilePlainArgs.builder()
            .instanceId(instanceId.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .securityProfileId(securityProfileId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetSecurityProfilePlainArgs].
 */
@PulumiTagMarker
public class GetSecurityProfilePlainArgsBuilder internal constructor() {
    private var instanceId: String? = null

    private var name: String? = null

    private var securityProfileId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Reference to the hosting Amazon Connect Instance
     */
    @JvmName("bajbtectcpyobkap")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value Returns information on a specific Security Profile by name
     */
    @JvmName("ivftwykescvuvnhh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Returns information on a specific Security Profile by Security Profile id
     */
    @JvmName("yvxifswggvdwetuc")
    public suspend fun securityProfileId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.securityProfileId = mapped
    }

    /**
     * @param value Map of tags to assign to the Security Profile.
     */
    @JvmName("yditfwgpihrhitju")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the Security Profile.
     */
    @JvmName("hrfaqihyhwsqbbqx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetSecurityProfilePlainArgs = GetSecurityProfilePlainArgs(
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        name = name,
        securityProfileId = securityProfileId,
        tags = tags,
    )
}
