@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.GetUserHierarchyGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUserHierarchyGroup.
 * @property hierarchyGroupId Returns information on a specific hierarchy group by hierarchy group id
 * @property instanceId Reference to the hosting Amazon Connect Instance
 * @property name Returns information on a specific hierarchy group by name
 * @property tags Map of tags to assign to the hierarchy group.
 */
public data class GetUserHierarchyGroupPlainArgs(
    public val hierarchyGroupId: String? = null,
    public val instanceId: String,
    public val name: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.GetUserHierarchyGroupPlainArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.GetUserHierarchyGroupPlainArgs =
        com.pulumi.aws.connect.inputs.GetUserHierarchyGroupPlainArgs.builder()
            .hierarchyGroupId(hierarchyGroupId?.let({ args0 -> args0 }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetUserHierarchyGroupPlainArgs].
 */
@PulumiTagMarker
public class GetUserHierarchyGroupPlainArgsBuilder internal constructor() {
    private var hierarchyGroupId: String? = null

    private var instanceId: String? = null

    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Returns information on a specific hierarchy group by hierarchy group id
     */
    @JvmName("ekttsxlxfnssykcu")
    public suspend fun hierarchyGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hierarchyGroupId = mapped
    }

    /**
     * @param value Reference to the hosting Amazon Connect Instance
     */
    @JvmName("oegumneurftxklnu")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value Returns information on a specific hierarchy group by name
     */
    @JvmName("guvkseybyosukhhs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Map of tags to assign to the hierarchy group.
     */
    @JvmName("pjlaaxhdjvmoqhye")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the hierarchy group.
     */
    @JvmName("ubeviamrtvcmutyq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetUserHierarchyGroupPlainArgs = GetUserHierarchyGroupPlainArgs(
        hierarchyGroupId = hierarchyGroupId,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        name = name,
        tags = tags,
    )
}
