@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.GetUserPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUser.
 * @property instanceId Reference to the hosting Amazon Connect Instance
 * @property name Returns information on a specific User by name
 * @property tags A map of tags to assign to the User.
 * @property userId Returns information on a specific User by User id
 */
public data class GetUserPlainArgs(
    public val instanceId: String,
    public val name: String? = null,
    public val tags: Map<String, String>? = null,
    public val userId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.GetUserPlainArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.GetUserPlainArgs =
        com.pulumi.aws.connect.inputs.GetUserPlainArgs.builder()
            .instanceId(instanceId.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userId(userId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserPlainArgs].
 */
@PulumiTagMarker
public class GetUserPlainArgsBuilder internal constructor() {
    private var instanceId: String? = null

    private var name: String? = null

    private var tags: Map<String, String>? = null

    private var userId: String? = null

    /**
     * @param value Reference to the hosting Amazon Connect Instance
     */
    @JvmName("tdljrdtbqltvtxcb")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value Returns information on a specific User by name
     */
    @JvmName("innkjwnpkeykfgjm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the User.
     */
    @JvmName("iuinutvbnilwfvda")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the User.
     */
    @JvmName("mtpeddeynkqsikjm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Returns information on a specific User by User id
     */
    @JvmName("lepyoordtfovuwjk")
    public suspend fun userId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.userId = mapped
    }

    internal fun build(): GetUserPlainArgs = GetUserPlainArgs(
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        name = name,
        tags = tags,
        userId = userId,
    )
}
