@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.GetVocabularyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVocabulary.
 * @property instanceId Reference to the hosting Amazon Connect Instance
 * @property name Returns information on a specific Vocabulary by name
 * @property tags A map of tags to assign to the Vocabulary.
 * @property vocabularyId Returns information on a specific Vocabulary by Vocabulary id
 */
public data class GetVocabularyPlainArgs(
    public val instanceId: String,
    public val name: String? = null,
    public val tags: Map<String, String>? = null,
    public val vocabularyId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.GetVocabularyPlainArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.GetVocabularyPlainArgs =
        com.pulumi.aws.connect.inputs.GetVocabularyPlainArgs.builder()
            .instanceId(instanceId.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vocabularyId(vocabularyId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVocabularyPlainArgs].
 */
@PulumiTagMarker
public class GetVocabularyPlainArgsBuilder internal constructor() {
    private var instanceId: String? = null

    private var name: String? = null

    private var tags: Map<String, String>? = null

    private var vocabularyId: String? = null

    /**
     * @param value Reference to the hosting Amazon Connect Instance
     */
    @JvmName("krfvgpwsunlcvccj")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value Returns information on a specific Vocabulary by name
     */
    @JvmName("blxyqdilpsmbkqxo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the Vocabulary.
     */
    @JvmName("oeuteaumvwodinte")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the Vocabulary.
     */
    @JvmName("vhbmikxyrtaqdxch")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Returns information on a specific Vocabulary by Vocabulary id
     */
    @JvmName("gcovalhrwggthlso")
    public suspend fun vocabularyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vocabularyId = mapped
    }

    internal fun build(): GetVocabularyPlainArgs = GetVocabularyPlainArgs(
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        name = name,
        tags = tags,
        vocabularyId = vocabularyId,
    )
}
