@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.HoursOfOperationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property day Specifies the day that the hours of operation applies to.
 * @property endTime A end time block specifies the time that your contact center closes. The `end_time` is documented below.
 * @property startTime A start time block specifies the time that your contact center opens. The `start_time` is documented below.
 */
public data class HoursOfOperationConfigArgs(
    public val day: Output<String>,
    public val endTime: Output<HoursOfOperationConfigEndTimeArgs>,
    public val startTime: Output<HoursOfOperationConfigStartTimeArgs>,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.HoursOfOperationConfigArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.HoursOfOperationConfigArgs =
        com.pulumi.aws.connect.inputs.HoursOfOperationConfigArgs.builder()
            .day(day.applyValue({ args0 -> args0 }))
            .endTime(endTime.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .startTime(startTime.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [HoursOfOperationConfigArgs].
 */
@PulumiTagMarker
public class HoursOfOperationConfigArgsBuilder internal constructor() {
    private var day: Output<String>? = null

    private var endTime: Output<HoursOfOperationConfigEndTimeArgs>? = null

    private var startTime: Output<HoursOfOperationConfigStartTimeArgs>? = null

    /**
     * @param value Specifies the day that the hours of operation applies to.
     */
    @JvmName("kxnxrhxprnuwljxg")
    public suspend fun day(`value`: Output<String>) {
        this.day = value
    }

    /**
     * @param value A end time block specifies the time that your contact center closes. The `end_time` is documented below.
     */
    @JvmName("qqalayssaqwvjjwi")
    public suspend fun endTime(`value`: Output<HoursOfOperationConfigEndTimeArgs>) {
        this.endTime = value
    }

    /**
     * @param value A start time block specifies the time that your contact center opens. The `start_time` is documented below.
     */
    @JvmName("xsicnhjwuodjabfh")
    public suspend fun startTime(`value`: Output<HoursOfOperationConfigStartTimeArgs>) {
        this.startTime = value
    }

    /**
     * @param value Specifies the day that the hours of operation applies to.
     */
    @JvmName("bcinugcburitblbv")
    public suspend fun day(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.day = mapped
    }

    /**
     * @param value A end time block specifies the time that your contact center closes. The `end_time` is documented below.
     */
    @JvmName("qpwmrmxptceaxpde")
    public suspend fun endTime(`value`: HoursOfOperationConfigEndTimeArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param argument A end time block specifies the time that your contact center closes. The `end_time` is documented below.
     */
    @JvmName("fuhosrjeqbmnklli")
    public suspend
    fun endTime(argument: suspend HoursOfOperationConfigEndTimeArgsBuilder.() -> Unit) {
        val toBeMapped = HoursOfOperationConfigEndTimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.endTime = mapped
    }

    /**
     * @param value A start time block specifies the time that your contact center opens. The `start_time` is documented below.
     */
    @JvmName("yxtcgjbrdsosiqby")
    public suspend fun startTime(`value`: HoursOfOperationConfigStartTimeArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param argument A start time block specifies the time that your contact center opens. The `start_time` is documented below.
     */
    @JvmName("piktkciowfueehop")
    public suspend
    fun startTime(argument: suspend HoursOfOperationConfigStartTimeArgsBuilder.() -> Unit) {
        val toBeMapped = HoursOfOperationConfigStartTimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.startTime = mapped
    }

    internal fun build(): HoursOfOperationConfigArgs = HoursOfOperationConfigArgs(
        day = day ?: throw PulumiNullFieldException("day"),
        endTime = endTime ?: throw PulumiNullFieldException("endTime"),
        startTime = startTime ?: throw PulumiNullFieldException("startTime"),
    )
}
