@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.HoursOfOperationConfigEndTimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hours Specifies the hour of closing.
 * @property minutes Specifies the minute of closing.
 */
public data class HoursOfOperationConfigEndTimeArgs(
    public val hours: Output<Int>,
    public val minutes: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.HoursOfOperationConfigEndTimeArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.HoursOfOperationConfigEndTimeArgs =
        com.pulumi.aws.connect.inputs.HoursOfOperationConfigEndTimeArgs.builder()
            .hours(hours.applyValue({ args0 -> args0 }))
            .minutes(minutes.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HoursOfOperationConfigEndTimeArgs].
 */
@PulumiTagMarker
public class HoursOfOperationConfigEndTimeArgsBuilder internal constructor() {
    private var hours: Output<Int>? = null

    private var minutes: Output<Int>? = null

    /**
     * @param value Specifies the hour of closing.
     */
    @JvmName("mosyfamyquhjkkrr")
    public suspend fun hours(`value`: Output<Int>) {
        this.hours = value
    }

    /**
     * @param value Specifies the minute of closing.
     */
    @JvmName("hlayeurpkgrqvlfs")
    public suspend fun minutes(`value`: Output<Int>) {
        this.minutes = value
    }

    /**
     * @param value Specifies the hour of closing.
     */
    @JvmName("vltikmucyxhjxfvb")
    public suspend fun hours(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hours = mapped
    }

    /**
     * @param value Specifies the minute of closing.
     */
    @JvmName("qfapthtatjunfhtv")
    public suspend fun minutes(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minutes = mapped
    }

    internal fun build(): HoursOfOperationConfigEndTimeArgs = HoursOfOperationConfigEndTimeArgs(
        hours = hours ?: throw PulumiNullFieldException("hours"),
        minutes = minutes ?: throw PulumiNullFieldException("minutes"),
    )
}
