@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property kinesisFirehoseConfig A block that specifies the configuration of the Kinesis Firehose delivery stream. Documented below.
 * @property kinesisStreamConfig A block that specifies the configuration of the Kinesis data stream. Documented below.
 * @property kinesisVideoStreamConfig A block that specifies the configuration of the Kinesis video stream. Documented below.
 * @property s3Config A block that specifies the configuration of S3 Bucket. Documented below.
 * @property storageType A valid storage type. Valid Values: `S3` | `KINESIS_VIDEO_STREAM` | `KINESIS_STREAM` | `KINESIS_FIREHOSE`.
 */
public data class InstanceStorageConfigStorageConfigArgs(
    public val kinesisFirehoseConfig:
    Output<InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs>? = null,
    public val kinesisStreamConfig: Output<InstanceStorageConfigStorageConfigKinesisStreamConfigArgs>? =
        null,
    public val kinesisVideoStreamConfig:
    Output<InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs>? = null,
    public val s3Config: Output<InstanceStorageConfigStorageConfigS3ConfigArgs>? = null,
    public val storageType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs =
        com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs.builder()
            .kinesisFirehoseConfig(
                kinesisFirehoseConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kinesisStreamConfig(
                kinesisStreamConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kinesisVideoStreamConfig(
                kinesisVideoStreamConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .s3Config(s3Config?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageType(storageType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceStorageConfigStorageConfigArgs].
 */
@PulumiTagMarker
public class InstanceStorageConfigStorageConfigArgsBuilder internal constructor() {
    private var kinesisFirehoseConfig:
        Output<InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs>? = null

    private var kinesisStreamConfig:
        Output<InstanceStorageConfigStorageConfigKinesisStreamConfigArgs>? = null

    private var kinesisVideoStreamConfig:
        Output<InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs>? = null

    private var s3Config: Output<InstanceStorageConfigStorageConfigS3ConfigArgs>? = null

    private var storageType: Output<String>? = null

    /**
     * @param value A block that specifies the configuration of the Kinesis Firehose delivery stream. Documented below.
     */
    @JvmName("iselwrjcdtjshxgf")
    public suspend
    fun kinesisFirehoseConfig(`value`: Output<InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs>) {
        this.kinesisFirehoseConfig = value
    }

    /**
     * @param value A block that specifies the configuration of the Kinesis data stream. Documented below.
     */
    @JvmName("ahtdsfaofrkuddbg")
    public suspend
    fun kinesisStreamConfig(`value`: Output<InstanceStorageConfigStorageConfigKinesisStreamConfigArgs>) {
        this.kinesisStreamConfig = value
    }

    /**
     * @param value A block that specifies the configuration of the Kinesis video stream. Documented below.
     */
    @JvmName("bduhyksifwnmmfoy")
    public suspend
    fun kinesisVideoStreamConfig(`value`: Output<InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs>) {
        this.kinesisVideoStreamConfig = value
    }

    /**
     * @param value A block that specifies the configuration of S3 Bucket. Documented below.
     */
    @JvmName("hvtfgwcvnrypwocl")
    public suspend fun s3Config(`value`: Output<InstanceStorageConfigStorageConfigS3ConfigArgs>) {
        this.s3Config = value
    }

    /**
     * @param value A valid storage type. Valid Values: `S3` | `KINESIS_VIDEO_STREAM` | `KINESIS_STREAM` | `KINESIS_FIREHOSE`.
     */
    @JvmName("trcdhuvjvcliqkua")
    public suspend fun storageType(`value`: Output<String>) {
        this.storageType = value
    }

    /**
     * @param value A block that specifies the configuration of the Kinesis Firehose delivery stream. Documented below.
     */
    @JvmName("eljqlxbrxfdgyoaw")
    public suspend
    fun kinesisFirehoseConfig(`value`: InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisFirehoseConfig = mapped
    }

    /**
     * @param argument A block that specifies the configuration of the Kinesis Firehose delivery stream. Documented below.
     */
    @JvmName("llpfesxehcrvkpbr")
    public suspend
    fun kinesisFirehoseConfig(argument: suspend InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.kinesisFirehoseConfig = mapped
    }

    /**
     * @param value A block that specifies the configuration of the Kinesis data stream. Documented below.
     */
    @JvmName("rjwcxenwxnjmsfen")
    public suspend
    fun kinesisStreamConfig(`value`: InstanceStorageConfigStorageConfigKinesisStreamConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisStreamConfig = mapped
    }

    /**
     * @param argument A block that specifies the configuration of the Kinesis data stream. Documented below.
     */
    @JvmName("wttehwcxnbaqpyhx")
    public suspend
    fun kinesisStreamConfig(argument: suspend InstanceStorageConfigStorageConfigKinesisStreamConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            InstanceStorageConfigStorageConfigKinesisStreamConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.kinesisStreamConfig = mapped
    }

    /**
     * @param value A block that specifies the configuration of the Kinesis video stream. Documented below.
     */
    @JvmName("hgpmbpsyhykqsjeu")
    public suspend
    fun kinesisVideoStreamConfig(`value`: InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisVideoStreamConfig = mapped
    }

    /**
     * @param argument A block that specifies the configuration of the Kinesis video stream. Documented below.
     */
    @JvmName("qjkhukbjemwsqrxp")
    public suspend
    fun kinesisVideoStreamConfig(argument: suspend InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.kinesisVideoStreamConfig = mapped
    }

    /**
     * @param value A block that specifies the configuration of S3 Bucket. Documented below.
     */
    @JvmName("ltdltkdghrswfmqw")
    public suspend fun s3Config(`value`: InstanceStorageConfigStorageConfigS3ConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Config = mapped
    }

    /**
     * @param argument A block that specifies the configuration of S3 Bucket. Documented below.
     */
    @JvmName("jdcxqbbcagitdvuw")
    public suspend
    fun s3Config(argument: suspend InstanceStorageConfigStorageConfigS3ConfigArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceStorageConfigStorageConfigS3ConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3Config = mapped
    }

    /**
     * @param value A valid storage type. Valid Values: `S3` | `KINESIS_VIDEO_STREAM` | `KINESIS_STREAM` | `KINESIS_FIREHOSE`.
     */
    @JvmName("ggqrpfokcwfhnxjm")
    public suspend fun storageType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    internal fun build(): InstanceStorageConfigStorageConfigArgs =
        InstanceStorageConfigStorageConfigArgs(
            kinesisFirehoseConfig = kinesisFirehoseConfig,
            kinesisStreamConfig = kinesisStreamConfig,
            kinesisVideoStreamConfig = kinesisVideoStreamConfig,
            s3Config = s3Config,
            storageType = storageType ?: throw PulumiNullFieldException("storageType"),
        )
}
