@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property firehoseArn The Amazon Resource Name (ARN) of the delivery stream.
 */
public data class InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs(
    public val firehoseArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs> {
    override fun toJava():
        com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs =
        com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs.builder()
            .firehoseArn(firehoseArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs].
 */
@PulumiTagMarker
public class InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgsBuilder internal
constructor() {
    private var firehoseArn: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the delivery stream.
     */
    @JvmName("uxvxmcwyxqgveuuy")
    public suspend fun firehoseArn(`value`: Output<String>) {
        this.firehoseArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the delivery stream.
     */
    @JvmName("lejqrclwncfixypl")
    public suspend fun firehoseArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.firehoseArn = mapped
    }

    internal fun build(): InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs =
        InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs(
            firehoseArn = firehoseArn ?: throw PulumiNullFieldException("firehoseArn"),
        )
}
