@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property encryptionConfig The encryption configuration. Documented below.
 * @property prefix The prefix of the video stream. Minimum length of `1`. Maximum length of `128`. When read from the state, the value returned is `<prefix>-connect-<connect_instance_alias>-contact-` since the API appends additional details to the `prefix`.
 * @property retentionPeriodHours The number of hours data is retained in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream. Minimum value of `0`. Maximum value of `87600`. A value of `0`, indicates that the stream does not persist data.
 */
public data class InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs(
    public val encryptionConfig:
    Output<InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs>,
    public val prefix: Output<String>,
    public val retentionPeriodHours: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs> {
    override fun toJava():
        com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs =
        com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs.builder()
            .encryptionConfig(encryptionConfig.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .prefix(prefix.applyValue({ args0 -> args0 }))
            .retentionPeriodHours(retentionPeriodHours.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs].
 */
@PulumiTagMarker
public class InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgsBuilder internal
constructor() {
    private var encryptionConfig:
        Output<InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs>? = null

    private var prefix: Output<String>? = null

    private var retentionPeriodHours: Output<Int>? = null

    /**
     * @param value The encryption configuration. Documented below.
     */
    @JvmName("vktlrwftvscefsrk")
    public suspend
    fun encryptionConfig(`value`: Output<InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs>) {
        this.encryptionConfig = value
    }

    /**
     * @param value The prefix of the video stream. Minimum length of `1`. Maximum length of `128`. When read from the state, the value returned is `<prefix>-connect-<connect_instance_alias>-contact-` since the API appends additional details to the `prefix`.
     */
    @JvmName("nrtmvemklwhovyud")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value The number of hours data is retained in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream. Minimum value of `0`. Maximum value of `87600`. A value of `0`, indicates that the stream does not persist data.
     */
    @JvmName("coxgvhctcpwhhlde")
    public suspend fun retentionPeriodHours(`value`: Output<Int>) {
        this.retentionPeriodHours = value
    }

    /**
     * @param value The encryption configuration. Documented below.
     */
    @JvmName("utxfhituccujgjmy")
    public suspend
    fun encryptionConfig(`value`: InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionConfig = mapped
    }

    /**
     * @param argument The encryption configuration. Documented below.
     */
    @JvmName("imoienanhpsbcacd")
    public suspend
    fun encryptionConfig(argument: suspend InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.encryptionConfig = mapped
    }

    /**
     * @param value The prefix of the video stream. Minimum length of `1`. Maximum length of `128`. When read from the state, the value returned is `<prefix>-connect-<connect_instance_alias>-contact-` since the API appends additional details to the `prefix`.
     */
    @JvmName("vywpucmgfjmqtkfx")
    public suspend fun prefix(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value The number of hours data is retained in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream. Minimum value of `0`. Maximum value of `87600`. A value of `0`, indicates that the stream does not persist data.
     */
    @JvmName("gutmrboxxnbhbjlj")
    public suspend fun retentionPeriodHours(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionPeriodHours = mapped
    }

    internal fun build(): InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs =
        InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs(
            encryptionConfig = encryptionConfig ?: throw PulumiNullFieldException("encryptionConfig"),
            prefix = prefix ?: throw PulumiNullFieldException("prefix"),
            retentionPeriodHours = retentionPeriodHours ?: throw
                PulumiNullFieldException("retentionPeriodHours"),
        )
}
