@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property encryptionType The type of encryption. Valid Values: `KMS`.
 * @property keyId The full ARN of the encryption key. Be sure to provide the full ARN of the encryption key, not just the ID.
 */
public data class InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs(
    public val encryptionType: Output<String>,
    public val keyId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs> {
    override fun toJava():
        com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs =
        com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs.builder()
            .encryptionType(encryptionType.applyValue({ args0 -> args0 }))
            .keyId(keyId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs].
 */
@PulumiTagMarker
public class InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgsBuilder
internal constructor() {
    private var encryptionType: Output<String>? = null

    private var keyId: Output<String>? = null

    /**
     * @param value The type of encryption. Valid Values: `KMS`.
     */
    @JvmName("dnrshmqsmdfcqnfs")
    public suspend fun encryptionType(`value`: Output<String>) {
        this.encryptionType = value
    }

    /**
     * @param value The full ARN of the encryption key. Be sure to provide the full ARN of the encryption key, not just the ID.
     */
    @JvmName("nmmemlkgchmnprco")
    public suspend fun keyId(`value`: Output<String>) {
        this.keyId = value
    }

    /**
     * @param value The type of encryption. Valid Values: `KMS`.
     */
    @JvmName("andxgghmgrwdiqil")
    public suspend fun encryptionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionType = mapped
    }

    /**
     * @param value The full ARN of the encryption key. Be sure to provide the full ARN of the encryption key, not just the ID.
     */
    @JvmName("wjoetxxneohtuumj")
    public suspend fun keyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyId = mapped
    }

    internal fun build():
        InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs =
        InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs(
            encryptionType = encryptionType ?: throw PulumiNullFieldException("encryptionType"),
            keyId = keyId ?: throw PulumiNullFieldException("keyId"),
        )
}
