@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigS3ConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName The S3 bucket name.
 * @property bucketPrefix The S3 bucket prefix.
 * @property encryptionConfig The encryption configuration. Documented below.
 */
public data class InstanceStorageConfigStorageConfigS3ConfigArgs(
    public val bucketName: Output<String>,
    public val bucketPrefix: Output<String>,
    public val encryptionConfig:
    Output<InstanceStorageConfigStorageConfigS3ConfigEncryptionConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigS3ConfigArgs> {
    override fun toJava():
        com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigS3ConfigArgs =
        com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigS3ConfigArgs.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .bucketPrefix(bucketPrefix.applyValue({ args0 -> args0 }))
            .encryptionConfig(
                encryptionConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [InstanceStorageConfigStorageConfigS3ConfigArgs].
 */
@PulumiTagMarker
public class InstanceStorageConfigStorageConfigS3ConfigArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var bucketPrefix: Output<String>? = null

    private var encryptionConfig:
        Output<InstanceStorageConfigStorageConfigS3ConfigEncryptionConfigArgs>? = null

    /**
     * @param value The S3 bucket name.
     */
    @JvmName("ppflxgomhcsjolpv")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value The S3 bucket prefix.
     */
    @JvmName("iqbrjcsvxvblvnuo")
    public suspend fun bucketPrefix(`value`: Output<String>) {
        this.bucketPrefix = value
    }

    /**
     * @param value The encryption configuration. Documented below.
     */
    @JvmName("aiuuolqkjyqbokvu")
    public suspend
    fun encryptionConfig(`value`: Output<InstanceStorageConfigStorageConfigS3ConfigEncryptionConfigArgs>) {
        this.encryptionConfig = value
    }

    /**
     * @param value The S3 bucket name.
     */
    @JvmName("aehhhseylesjsalp")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value The S3 bucket prefix.
     */
    @JvmName("jitxewvfmsqunece")
    public suspend fun bucketPrefix(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketPrefix = mapped
    }

    /**
     * @param value The encryption configuration. Documented below.
     */
    @JvmName("dmexwfnyixrpwvpr")
    public suspend
    fun encryptionConfig(`value`: InstanceStorageConfigStorageConfigS3ConfigEncryptionConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionConfig = mapped
    }

    /**
     * @param argument The encryption configuration. Documented below.
     */
    @JvmName("beogtaasvdaedcwa")
    public suspend
    fun encryptionConfig(argument: suspend InstanceStorageConfigStorageConfigS3ConfigEncryptionConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            InstanceStorageConfigStorageConfigS3ConfigEncryptionConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.encryptionConfig = mapped
    }

    internal fun build(): InstanceStorageConfigStorageConfigS3ConfigArgs =
        InstanceStorageConfigStorageConfigS3ConfigArgs(
            bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
            bucketPrefix = bucketPrefix ?: throw PulumiNullFieldException("bucketPrefix"),
            encryptionConfig = encryptionConfig,
        )
}
