@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.QueueOutboundCallerConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property outboundCallerIdName Specifies the caller ID name.
 * @property outboundCallerIdNumberId Specifies the caller ID number.
 * @property outboundFlowId Specifies outbound whisper flow to be used during an outbound call.
 */
public data class QueueOutboundCallerConfigArgs(
    public val outboundCallerIdName: Output<String>? = null,
    public val outboundCallerIdNumberId: Output<String>? = null,
    public val outboundFlowId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.QueueOutboundCallerConfigArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.QueueOutboundCallerConfigArgs =
        com.pulumi.aws.connect.inputs.QueueOutboundCallerConfigArgs.builder()
            .outboundCallerIdName(outboundCallerIdName?.applyValue({ args0 -> args0 }))
            .outboundCallerIdNumberId(outboundCallerIdNumberId?.applyValue({ args0 -> args0 }))
            .outboundFlowId(outboundFlowId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QueueOutboundCallerConfigArgs].
 */
@PulumiTagMarker
public class QueueOutboundCallerConfigArgsBuilder internal constructor() {
    private var outboundCallerIdName: Output<String>? = null

    private var outboundCallerIdNumberId: Output<String>? = null

    private var outboundFlowId: Output<String>? = null

    /**
     * @param value Specifies the caller ID name.
     */
    @JvmName("syjixowaqhcgabyq")
    public suspend fun outboundCallerIdName(`value`: Output<String>) {
        this.outboundCallerIdName = value
    }

    /**
     * @param value Specifies the caller ID number.
     */
    @JvmName("aamctepindkuqcwl")
    public suspend fun outboundCallerIdNumberId(`value`: Output<String>) {
        this.outboundCallerIdNumberId = value
    }

    /**
     * @param value Specifies outbound whisper flow to be used during an outbound call.
     */
    @JvmName("iuaxuplmcxnfepfx")
    public suspend fun outboundFlowId(`value`: Output<String>) {
        this.outboundFlowId = value
    }

    /**
     * @param value Specifies the caller ID name.
     */
    @JvmName("sfmjvovvhncshujc")
    public suspend fun outboundCallerIdName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundCallerIdName = mapped
    }

    /**
     * @param value Specifies the caller ID number.
     */
    @JvmName("pahsjsqcrisxfrwf")
    public suspend fun outboundCallerIdNumberId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundCallerIdNumberId = mapped
    }

    /**
     * @param value Specifies outbound whisper flow to be used during an outbound call.
     */
    @JvmName("einvjhrmsutrjlwa")
    public suspend fun outboundFlowId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundFlowId = mapped
    }

    internal fun build(): QueueOutboundCallerConfigArgs = QueueOutboundCallerConfigArgs(
        outboundCallerIdName = outboundCallerIdName,
        outboundCallerIdNumberId = outboundCallerIdNumberId,
        outboundFlowId = outboundFlowId,
    )
}
