@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.QuickConnectQuickConnectConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property phoneConfigs Specifies the phone configuration of the Quick Connect. This is required only if `quick_connect_type` is `PHONE_NUMBER`. The `phone_config` block is documented below.
 * @property queueConfigs Specifies the queue configuration of the Quick Connect. This is required only if `quick_connect_type` is `QUEUE`. The `queue_config` block is documented below.
 * @property quickConnectType Specifies the configuration type of the quick connect. valid values are `PHONE_NUMBER`, `QUEUE`, `USER`.
 * @property userConfigs Specifies the user configuration of the Quick Connect. This is required only if `quick_connect_type` is `USER`. The `user_config` block is documented below.
 */
public data class QuickConnectQuickConnectConfigArgs(
    public val phoneConfigs: Output<List<QuickConnectQuickConnectConfigPhoneConfigArgs>>? = null,
    public val queueConfigs: Output<List<QuickConnectQuickConnectConfigQueueConfigArgs>>? = null,
    public val quickConnectType: Output<String>,
    public val userConfigs: Output<List<QuickConnectQuickConnectConfigUserConfigArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.QuickConnectQuickConnectConfigArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.QuickConnectQuickConnectConfigArgs =
        com.pulumi.aws.connect.inputs.QuickConnectQuickConnectConfigArgs.builder()
            .phoneConfigs(
                phoneConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .queueConfigs(
                queueConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .quickConnectType(quickConnectType.applyValue({ args0 -> args0 }))
            .userConfigs(
                userConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [QuickConnectQuickConnectConfigArgs].
 */
@PulumiTagMarker
public class QuickConnectQuickConnectConfigArgsBuilder internal constructor() {
    private var phoneConfigs: Output<List<QuickConnectQuickConnectConfigPhoneConfigArgs>>? = null

    private var queueConfigs: Output<List<QuickConnectQuickConnectConfigQueueConfigArgs>>? = null

    private var quickConnectType: Output<String>? = null

    private var userConfigs: Output<List<QuickConnectQuickConnectConfigUserConfigArgs>>? = null

    /**
     * @param value Specifies the phone configuration of the Quick Connect. This is required only if `quick_connect_type` is `PHONE_NUMBER`. The `phone_config` block is documented below.
     */
    @JvmName("umeynfwxrlhlqnax")
    public suspend
    fun phoneConfigs(`value`: Output<List<QuickConnectQuickConnectConfigPhoneConfigArgs>>) {
        this.phoneConfigs = value
    }

    @JvmName("jdosrffvdhqtywix")
    public suspend fun phoneConfigs(
        vararg
        values: Output<QuickConnectQuickConnectConfigPhoneConfigArgs>,
    ) {
        this.phoneConfigs = Output.all(values.asList())
    }

    /**
     * @param values Specifies the phone configuration of the Quick Connect. This is required only if `quick_connect_type` is `PHONE_NUMBER`. The `phone_config` block is documented below.
     */
    @JvmName("idphuudwmapunjmb")
    public suspend
    fun phoneConfigs(values: List<Output<QuickConnectQuickConnectConfigPhoneConfigArgs>>) {
        this.phoneConfigs = Output.all(values)
    }

    /**
     * @param value Specifies the queue configuration of the Quick Connect. This is required only if `quick_connect_type` is `QUEUE`. The `queue_config` block is documented below.
     */
    @JvmName("edwmssfqxyxrwwoo")
    public suspend
    fun queueConfigs(`value`: Output<List<QuickConnectQuickConnectConfigQueueConfigArgs>>) {
        this.queueConfigs = value
    }

    @JvmName("uhyewlipoblgikeb")
    public suspend fun queueConfigs(
        vararg
        values: Output<QuickConnectQuickConnectConfigQueueConfigArgs>,
    ) {
        this.queueConfigs = Output.all(values.asList())
    }

    /**
     * @param values Specifies the queue configuration of the Quick Connect. This is required only if `quick_connect_type` is `QUEUE`. The `queue_config` block is documented below.
     */
    @JvmName("ywspvctlwxiwyivu")
    public suspend
    fun queueConfigs(values: List<Output<QuickConnectQuickConnectConfigQueueConfigArgs>>) {
        this.queueConfigs = Output.all(values)
    }

    /**
     * @param value Specifies the configuration type of the quick connect. valid values are `PHONE_NUMBER`, `QUEUE`, `USER`.
     */
    @JvmName("noheeggeejxivicu")
    public suspend fun quickConnectType(`value`: Output<String>) {
        this.quickConnectType = value
    }

    /**
     * @param value Specifies the user configuration of the Quick Connect. This is required only if `quick_connect_type` is `USER`. The `user_config` block is documented below.
     */
    @JvmName("xanruibburkbxilj")
    public suspend
    fun userConfigs(`value`: Output<List<QuickConnectQuickConnectConfigUserConfigArgs>>) {
        this.userConfigs = value
    }

    @JvmName("fuwnbbajxaanqnsa")
    public suspend fun userConfigs(
        vararg
        values: Output<QuickConnectQuickConnectConfigUserConfigArgs>,
    ) {
        this.userConfigs = Output.all(values.asList())
    }

    /**
     * @param values Specifies the user configuration of the Quick Connect. This is required only if `quick_connect_type` is `USER`. The `user_config` block is documented below.
     */
    @JvmName("bpnsmlvocduyrtrc")
    public suspend
    fun userConfigs(values: List<Output<QuickConnectQuickConnectConfigUserConfigArgs>>) {
        this.userConfigs = Output.all(values)
    }

    /**
     * @param value Specifies the phone configuration of the Quick Connect. This is required only if `quick_connect_type` is `PHONE_NUMBER`. The `phone_config` block is documented below.
     */
    @JvmName("yelvbfsxvvtdnkls")
    public suspend fun phoneConfigs(`value`: List<QuickConnectQuickConnectConfigPhoneConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneConfigs = mapped
    }

    /**
     * @param argument Specifies the phone configuration of the Quick Connect. This is required only if `quick_connect_type` is `PHONE_NUMBER`. The `phone_config` block is documented below.
     */
    @JvmName("vwimsnyayjackimc")
    public suspend
    fun phoneConfigs(argument: List<suspend QuickConnectQuickConnectConfigPhoneConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            QuickConnectQuickConnectConfigPhoneConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.phoneConfigs = mapped
    }

    /**
     * @param argument Specifies the phone configuration of the Quick Connect. This is required only if `quick_connect_type` is `PHONE_NUMBER`. The `phone_config` block is documented below.
     */
    @JvmName("juqfukhuvsvkuhap")
    public suspend fun phoneConfigs(
        vararg
        argument: suspend QuickConnectQuickConnectConfigPhoneConfigArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            QuickConnectQuickConnectConfigPhoneConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.phoneConfigs = mapped
    }

    /**
     * @param argument Specifies the phone configuration of the Quick Connect. This is required only if `quick_connect_type` is `PHONE_NUMBER`. The `phone_config` block is documented below.
     */
    @JvmName("qrxjwdvpuuqntvyu")
    public suspend
    fun phoneConfigs(argument: suspend QuickConnectQuickConnectConfigPhoneConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            QuickConnectQuickConnectConfigPhoneConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.phoneConfigs = mapped
    }

    /**
     * @param values Specifies the phone configuration of the Quick Connect. This is required only if `quick_connect_type` is `PHONE_NUMBER`. The `phone_config` block is documented below.
     */
    @JvmName("xenysdfvctictvjj")
    public suspend fun phoneConfigs(vararg values: QuickConnectQuickConnectConfigPhoneConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.phoneConfigs = mapped
    }

    /**
     * @param value Specifies the queue configuration of the Quick Connect. This is required only if `quick_connect_type` is `QUEUE`. The `queue_config` block is documented below.
     */
    @JvmName("cfhuhidpcnrbfblh")
    public suspend fun queueConfigs(`value`: List<QuickConnectQuickConnectConfigQueueConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueConfigs = mapped
    }

    /**
     * @param argument Specifies the queue configuration of the Quick Connect. This is required only if `quick_connect_type` is `QUEUE`. The `queue_config` block is documented below.
     */
    @JvmName("lajcdifkfvoxgjij")
    public suspend
    fun queueConfigs(argument: List<suspend QuickConnectQuickConnectConfigQueueConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            QuickConnectQuickConnectConfigQueueConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.queueConfigs = mapped
    }

    /**
     * @param argument Specifies the queue configuration of the Quick Connect. This is required only if `quick_connect_type` is `QUEUE`. The `queue_config` block is documented below.
     */
    @JvmName("otklgfutunbnjtim")
    public suspend fun queueConfigs(
        vararg
        argument: suspend QuickConnectQuickConnectConfigQueueConfigArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            QuickConnectQuickConnectConfigQueueConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.queueConfigs = mapped
    }

    /**
     * @param argument Specifies the queue configuration of the Quick Connect. This is required only if `quick_connect_type` is `QUEUE`. The `queue_config` block is documented below.
     */
    @JvmName("iphiwijyfvrnaycn")
    public suspend
    fun queueConfigs(argument: suspend QuickConnectQuickConnectConfigQueueConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            QuickConnectQuickConnectConfigQueueConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.queueConfigs = mapped
    }

    /**
     * @param values Specifies the queue configuration of the Quick Connect. This is required only if `quick_connect_type` is `QUEUE`. The `queue_config` block is documented below.
     */
    @JvmName("abomfplbsfnkcpyy")
    public suspend fun queueConfigs(vararg values: QuickConnectQuickConnectConfigQueueConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queueConfigs = mapped
    }

    /**
     * @param value Specifies the configuration type of the quick connect. valid values are `PHONE_NUMBER`, `QUEUE`, `USER`.
     */
    @JvmName("iypsflbbfxnjvaom")
    public suspend fun quickConnectType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.quickConnectType = mapped
    }

    /**
     * @param value Specifies the user configuration of the Quick Connect. This is required only if `quick_connect_type` is `USER`. The `user_config` block is documented below.
     */
    @JvmName("gnmersmjxwxrwqdf")
    public suspend fun userConfigs(`value`: List<QuickConnectQuickConnectConfigUserConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userConfigs = mapped
    }

    /**
     * @param argument Specifies the user configuration of the Quick Connect. This is required only if `quick_connect_type` is `USER`. The `user_config` block is documented below.
     */
    @JvmName("auuquotqvsecukjl")
    public suspend
    fun userConfigs(argument: List<suspend QuickConnectQuickConnectConfigUserConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            QuickConnectQuickConnectConfigUserConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userConfigs = mapped
    }

    /**
     * @param argument Specifies the user configuration of the Quick Connect. This is required only if `quick_connect_type` is `USER`. The `user_config` block is documented below.
     */
    @JvmName("tpnycoyfngdvfyjf")
    public suspend fun userConfigs(
        vararg
        argument: suspend QuickConnectQuickConnectConfigUserConfigArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            QuickConnectQuickConnectConfigUserConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userConfigs = mapped
    }

    /**
     * @param argument Specifies the user configuration of the Quick Connect. This is required only if `quick_connect_type` is `USER`. The `user_config` block is documented below.
     */
    @JvmName("qnteringphbyfela")
    public suspend
    fun userConfigs(argument: suspend QuickConnectQuickConnectConfigUserConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            QuickConnectQuickConnectConfigUserConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.userConfigs = mapped
    }

    /**
     * @param values Specifies the user configuration of the Quick Connect. This is required only if `quick_connect_type` is `USER`. The `user_config` block is documented below.
     */
    @JvmName("tdkqmnqqwmyalduk")
    public suspend fun userConfigs(vararg values: QuickConnectQuickConnectConfigUserConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userConfigs = mapped
    }

    internal fun build(): QuickConnectQuickConnectConfigArgs = QuickConnectQuickConnectConfigArgs(
        phoneConfigs = phoneConfigs,
        queueConfigs = queueConfigs,
        quickConnectType = quickConnectType ?: throw PulumiNullFieldException("quickConnectType"),
        userConfigs = userConfigs,
    )
}
