@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.QuickConnectQuickConnectConfigPhoneConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property phoneNumber Specifies the phone number in in E.164 format.
 */
public data class QuickConnectQuickConnectConfigPhoneConfigArgs(
    public val phoneNumber: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.QuickConnectQuickConnectConfigPhoneConfigArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.QuickConnectQuickConnectConfigPhoneConfigArgs =
        com.pulumi.aws.connect.inputs.QuickConnectQuickConnectConfigPhoneConfigArgs.builder()
            .phoneNumber(phoneNumber.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QuickConnectQuickConnectConfigPhoneConfigArgs].
 */
@PulumiTagMarker
public class QuickConnectQuickConnectConfigPhoneConfigArgsBuilder internal constructor() {
    private var phoneNumber: Output<String>? = null

    /**
     * @param value Specifies the phone number in in E.164 format.
     */
    @JvmName("xkbluplmkcnyopua")
    public suspend fun phoneNumber(`value`: Output<String>) {
        this.phoneNumber = value
    }

    /**
     * @param value Specifies the phone number in in E.164 format.
     */
    @JvmName("kbslwaxegcmaixkw")
    public suspend fun phoneNumber(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.phoneNumber = mapped
    }

    internal fun build(): QuickConnectQuickConnectConfigPhoneConfigArgs =
        QuickConnectQuickConnectConfigPhoneConfigArgs(
            phoneNumber = phoneNumber ?: throw PulumiNullFieldException("phoneNumber"),
        )
}
