@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.QuickConnectQuickConnectConfigQueueConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property contactFlowId Specifies the identifier of the contact flow.
 * @property queueId Specifies the identifier for the queue.
 */
public data class QuickConnectQuickConnectConfigQueueConfigArgs(
    public val contactFlowId: Output<String>,
    public val queueId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.QuickConnectQuickConnectConfigQueueConfigArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.QuickConnectQuickConnectConfigQueueConfigArgs =
        com.pulumi.aws.connect.inputs.QuickConnectQuickConnectConfigQueueConfigArgs.builder()
            .contactFlowId(contactFlowId.applyValue({ args0 -> args0 }))
            .queueId(queueId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QuickConnectQuickConnectConfigQueueConfigArgs].
 */
@PulumiTagMarker
public class QuickConnectQuickConnectConfigQueueConfigArgsBuilder internal constructor() {
    private var contactFlowId: Output<String>? = null

    private var queueId: Output<String>? = null

    /**
     * @param value Specifies the identifier of the contact flow.
     */
    @JvmName("xvhsnuvxiiffwbbv")
    public suspend fun contactFlowId(`value`: Output<String>) {
        this.contactFlowId = value
    }

    /**
     * @param value Specifies the identifier for the queue.
     */
    @JvmName("ushvaydeskrykfqa")
    public suspend fun queueId(`value`: Output<String>) {
        this.queueId = value
    }

    /**
     * @param value Specifies the identifier of the contact flow.
     */
    @JvmName("ofhshqvvxmlcfilm")
    public suspend fun contactFlowId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactFlowId = mapped
    }

    /**
     * @param value Specifies the identifier for the queue.
     */
    @JvmName("nuhbwvjtynhceiam")
    public suspend fun queueId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queueId = mapped
    }

    internal fun build(): QuickConnectQuickConnectConfigQueueConfigArgs =
        QuickConnectQuickConnectConfigQueueConfigArgs(
            contactFlowId = contactFlowId ?: throw PulumiNullFieldException("contactFlowId"),
            queueId = queueId ?: throw PulumiNullFieldException("queueId"),
        )
}
