@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.RoutingProfileMediaConcurrencyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property channel Specifies the channels that agents can handle in the Contact Control Panel (CCP). Valid values are `VOICE`, `CHAT`, `TASK`.
 * @property concurrency Specifies the number of contacts an agent can have on a channel simultaneously. Valid Range for `VOICE`: Minimum value of 1. Maximum value of 1. Valid Range for `CHAT`: Minimum value of 1. Maximum value of 10. Valid Range for `TASK`: Minimum value of 1. Maximum value of 10.
 */
public data class RoutingProfileMediaConcurrencyArgs(
    public val channel: Output<String>,
    public val concurrency: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.RoutingProfileMediaConcurrencyArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.RoutingProfileMediaConcurrencyArgs =
        com.pulumi.aws.connect.inputs.RoutingProfileMediaConcurrencyArgs.builder()
            .channel(channel.applyValue({ args0 -> args0 }))
            .concurrency(concurrency.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoutingProfileMediaConcurrencyArgs].
 */
@PulumiTagMarker
public class RoutingProfileMediaConcurrencyArgsBuilder internal constructor() {
    private var channel: Output<String>? = null

    private var concurrency: Output<Int>? = null

    /**
     * @param value Specifies the channels that agents can handle in the Contact Control Panel (CCP). Valid values are `VOICE`, `CHAT`, `TASK`.
     */
    @JvmName("fnjjwpkkdvcytucy")
    public suspend fun channel(`value`: Output<String>) {
        this.channel = value
    }

    /**
     * @param value Specifies the number of contacts an agent can have on a channel simultaneously. Valid Range for `VOICE`: Minimum value of 1. Maximum value of 1. Valid Range for `CHAT`: Minimum value of 1. Maximum value of 10. Valid Range for `TASK`: Minimum value of 1. Maximum value of 10.
     */
    @JvmName("uggprsepndxbxkbb")
    public suspend fun concurrency(`value`: Output<Int>) {
        this.concurrency = value
    }

    /**
     * @param value Specifies the channels that agents can handle in the Contact Control Panel (CCP). Valid values are `VOICE`, `CHAT`, `TASK`.
     */
    @JvmName("lxrcxmvjcmuadikk")
    public suspend fun channel(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channel = mapped
    }

    /**
     * @param value Specifies the number of contacts an agent can have on a channel simultaneously. Valid Range for `VOICE`: Minimum value of 1. Maximum value of 1. Valid Range for `CHAT`: Minimum value of 1. Maximum value of 10. Valid Range for `TASK`: Minimum value of 1. Maximum value of 10.
     */
    @JvmName("xrisuiowivqxjxyl")
    public suspend fun concurrency(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.concurrency = mapped
    }

    internal fun build(): RoutingProfileMediaConcurrencyArgs = RoutingProfileMediaConcurrencyArgs(
        channel = channel ?: throw PulumiNullFieldException("channel"),
        concurrency = concurrency ?: throw PulumiNullFieldException("concurrency"),
    )
}
