@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property levelFive A block that defines the details of level five. The level block is documented below.
 * Each level block supports the following arguments:
 * @property levelFour A block that defines the details of level four. The level block is documented below.
 * @property levelOne A block that defines the details of level one. The level block is documented below.
 * @property levelThree A block that defines the details of level three. The level block is documented below.
 * @property levelTwo A block that defines the details of level two. The level block is documented below.
 */
public data class UserHierarchyStructureHierarchyStructureArgs(
    public val levelFive: Output<UserHierarchyStructureHierarchyStructureLevelFiveArgs>? = null,
    public val levelFour: Output<UserHierarchyStructureHierarchyStructureLevelFourArgs>? = null,
    public val levelOne: Output<UserHierarchyStructureHierarchyStructureLevelOneArgs>? = null,
    public val levelThree: Output<UserHierarchyStructureHierarchyStructureLevelThreeArgs>? = null,
    public val levelTwo: Output<UserHierarchyStructureHierarchyStructureLevelTwoArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureArgs =
        com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureArgs.builder()
            .levelFive(levelFive?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .levelFour(levelFour?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .levelOne(levelOne?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .levelThree(levelThree?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .levelTwo(levelTwo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [UserHierarchyStructureHierarchyStructureArgs].
 */
@PulumiTagMarker
public class UserHierarchyStructureHierarchyStructureArgsBuilder internal constructor() {
    private var levelFive: Output<UserHierarchyStructureHierarchyStructureLevelFiveArgs>? = null

    private var levelFour: Output<UserHierarchyStructureHierarchyStructureLevelFourArgs>? = null

    private var levelOne: Output<UserHierarchyStructureHierarchyStructureLevelOneArgs>? = null

    private var levelThree: Output<UserHierarchyStructureHierarchyStructureLevelThreeArgs>? = null

    private var levelTwo: Output<UserHierarchyStructureHierarchyStructureLevelTwoArgs>? = null

    /**
     * @param value A block that defines the details of level five. The level block is documented below.
     * Each level block supports the following arguments:
     */
    @JvmName("wrcdksghisgdrtod")
    public suspend
    fun levelFive(`value`: Output<UserHierarchyStructureHierarchyStructureLevelFiveArgs>) {
        this.levelFive = value
    }

    /**
     * @param value A block that defines the details of level four. The level block is documented below.
     */
    @JvmName("cjqtbmvvmgftbdaq")
    public suspend
    fun levelFour(`value`: Output<UserHierarchyStructureHierarchyStructureLevelFourArgs>) {
        this.levelFour = value
    }

    /**
     * @param value A block that defines the details of level one. The level block is documented below.
     */
    @JvmName("kpknfxfpfyyajbbj")
    public suspend
    fun levelOne(`value`: Output<UserHierarchyStructureHierarchyStructureLevelOneArgs>) {
        this.levelOne = value
    }

    /**
     * @param value A block that defines the details of level three. The level block is documented below.
     */
    @JvmName("sumhxrobqgncrddv")
    public suspend
    fun levelThree(`value`: Output<UserHierarchyStructureHierarchyStructureLevelThreeArgs>) {
        this.levelThree = value
    }

    /**
     * @param value A block that defines the details of level two. The level block is documented below.
     */
    @JvmName("jrbjinotwltvngqu")
    public suspend
    fun levelTwo(`value`: Output<UserHierarchyStructureHierarchyStructureLevelTwoArgs>) {
        this.levelTwo = value
    }

    /**
     * @param value A block that defines the details of level five. The level block is documented below.
     * Each level block supports the following arguments:
     */
    @JvmName("cylayxudkknmnslt")
    public suspend fun levelFive(`value`: UserHierarchyStructureHierarchyStructureLevelFiveArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.levelFive = mapped
    }

    /**
     * @param argument A block that defines the details of level five. The level block is documented below.
     * Each level block supports the following arguments:
     */
    @JvmName("rdowasfqgejaehlt")
    public suspend
    fun levelFive(argument: suspend UserHierarchyStructureHierarchyStructureLevelFiveArgsBuilder.() -> Unit) {
        val toBeMapped = UserHierarchyStructureHierarchyStructureLevelFiveArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.levelFive = mapped
    }

    /**
     * @param value A block that defines the details of level four. The level block is documented below.
     */
    @JvmName("mtsrqkkmehxopgbk")
    public suspend fun levelFour(`value`: UserHierarchyStructureHierarchyStructureLevelFourArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.levelFour = mapped
    }

    /**
     * @param argument A block that defines the details of level four. The level block is documented below.
     */
    @JvmName("ueffxhxdqqlboyqx")
    public suspend
    fun levelFour(argument: suspend UserHierarchyStructureHierarchyStructureLevelFourArgsBuilder.() -> Unit) {
        val toBeMapped = UserHierarchyStructureHierarchyStructureLevelFourArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.levelFour = mapped
    }

    /**
     * @param value A block that defines the details of level one. The level block is documented below.
     */
    @JvmName("jckaqncaijfnioyp")
    public suspend fun levelOne(`value`: UserHierarchyStructureHierarchyStructureLevelOneArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.levelOne = mapped
    }

    /**
     * @param argument A block that defines the details of level one. The level block is documented below.
     */
    @JvmName("ldjmlkfwoklutdsx")
    public suspend
    fun levelOne(argument: suspend UserHierarchyStructureHierarchyStructureLevelOneArgsBuilder.() -> Unit) {
        val toBeMapped = UserHierarchyStructureHierarchyStructureLevelOneArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.levelOne = mapped
    }

    /**
     * @param value A block that defines the details of level three. The level block is documented below.
     */
    @JvmName("pmhougmayrfsfibk")
    public suspend fun levelThree(`value`: UserHierarchyStructureHierarchyStructureLevelThreeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.levelThree = mapped
    }

    /**
     * @param argument A block that defines the details of level three. The level block is documented below.
     */
    @JvmName("wiwecqmcslpaybuo")
    public suspend
    fun levelThree(argument: suspend UserHierarchyStructureHierarchyStructureLevelThreeArgsBuilder.() -> Unit) {
        val toBeMapped = UserHierarchyStructureHierarchyStructureLevelThreeArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.levelThree = mapped
    }

    /**
     * @param value A block that defines the details of level two. The level block is documented below.
     */
    @JvmName("dhogutqpsgmbdpic")
    public suspend fun levelTwo(`value`: UserHierarchyStructureHierarchyStructureLevelTwoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.levelTwo = mapped
    }

    /**
     * @param argument A block that defines the details of level two. The level block is documented below.
     */
    @JvmName("fdsyfbdkrtnqndlu")
    public suspend
    fun levelTwo(argument: suspend UserHierarchyStructureHierarchyStructureLevelTwoArgsBuilder.() -> Unit) {
        val toBeMapped = UserHierarchyStructureHierarchyStructureLevelTwoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.levelTwo = mapped
    }

    internal fun build(): UserHierarchyStructureHierarchyStructureArgs =
        UserHierarchyStructureHierarchyStructureArgs(
            levelFive = levelFive,
            levelFour = levelFour,
            levelOne = levelOne,
            levelThree = levelThree,
            levelTwo = levelTwo,
        )
}
