@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.UserIdentityInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property email The email address. If you are using SAML for identity management and include this parameter, an error is returned. Note that updates to the `email` is supported. From the [UpdateUserIdentityInfo API documentation](https://docs&#46;aws&#46;amazon&#46;com/connect/latest/APIReference/API_UpdateUserIdentityInfo&#46;html) it is strongly recommended to limit who has the ability to invoke `UpdateUserIdentityInfo`&#46; Someone with that ability can change the login credentials of other users by changing their email address&#46; This poses a security risk to your organization&#46; They can change the email address of a user to the attacker's email address, and then reset the password through email&#46; For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the Amazon Connect Administrator Guide.
 * @property firstName The first name. This is required if you are using Amazon Connect or SAML for identity management. Minimum length of 1. Maximum length of 100.
 * @property lastName The last name. This is required if you are using Amazon Connect or SAML for identity management. Minimum length of 1. Maximum length of 100.
 */
public data class UserIdentityInfoArgs(
    public val email: Output<String>? = null,
    public val firstName: Output<String>? = null,
    public val lastName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.UserIdentityInfoArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.UserIdentityInfoArgs =
        com.pulumi.aws.connect.inputs.UserIdentityInfoArgs.builder()
            .email(email?.applyValue({ args0 -> args0 }))
            .firstName(firstName?.applyValue({ args0 -> args0 }))
            .lastName(lastName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserIdentityInfoArgs].
 */
@PulumiTagMarker
public class UserIdentityInfoArgsBuilder internal constructor() {
    private var email: Output<String>? = null

    private var firstName: Output<String>? = null

    private var lastName: Output<String>? = null

    /**
     * @param value The email address. If you are using SAML for identity management and include this parameter, an error is returned. Note that updates to the `email` is supported. From the [UpdateUserIdentityInfo API documentation](https://docs&#46;aws&#46;amazon&#46;com/connect/latest/APIReference/API_UpdateUserIdentityInfo&#46;html) it is strongly recommended to limit who has the ability to invoke `UpdateUserIdentityInfo`&#46; Someone with that ability can change the login credentials of other users by changing their email address&#46; This poses a security risk to your organization&#46; They can change the email address of a user to the attacker's email address, and then reset the password through email&#46; For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the Amazon Connect Administrator Guide.
     */
    @JvmName("kihyrplpsjhikbis")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value The first name. This is required if you are using Amazon Connect or SAML for identity management. Minimum length of 1. Maximum length of 100.
     */
    @JvmName("yhosoaiuwjqkwavf")
    public suspend fun firstName(`value`: Output<String>) {
        this.firstName = value
    }

    /**
     * @param value The last name. This is required if you are using Amazon Connect or SAML for identity management. Minimum length of 1. Maximum length of 100.
     */
    @JvmName("iensrythbwqgrcch")
    public suspend fun lastName(`value`: Output<String>) {
        this.lastName = value
    }

    /**
     * @param value The email address. If you are using SAML for identity management and include this parameter, an error is returned. Note that updates to the `email` is supported. From the [UpdateUserIdentityInfo API documentation](https://docs&#46;aws&#46;amazon&#46;com/connect/latest/APIReference/API_UpdateUserIdentityInfo&#46;html) it is strongly recommended to limit who has the ability to invoke `UpdateUserIdentityInfo`&#46; Someone with that ability can change the login credentials of other users by changing their email address&#46; This poses a security risk to your organization&#46; They can change the email address of a user to the attacker's email address, and then reset the password through email&#46; For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the Amazon Connect Administrator Guide.
     */
    @JvmName("nddghdqsrisrybpa")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value The first name. This is required if you are using Amazon Connect or SAML for identity management. Minimum length of 1. Maximum length of 100.
     */
    @JvmName("pxsujpwjbufvkdqe")
    public suspend fun firstName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstName = mapped
    }

    /**
     * @param value The last name. This is required if you are using Amazon Connect or SAML for identity management. Minimum length of 1. Maximum length of 100.
     */
    @JvmName("bplfbeixhqtfljfu")
    public suspend fun lastName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastName = mapped
    }

    internal fun build(): UserIdentityInfoArgs = UserIdentityInfoArgs(
        email = email,
        firstName = firstName,
        lastName = lastName,
    )
}
