@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property lexRegion The Region that the Amazon Lex (V1) bot was created in. Defaults to current region.
 * @property name The name of the Amazon Lex (V1) bot.
 */
public data class BotAssociationLexBot(
    public val lexRegion: String? = null,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.BotAssociationLexBot):
            BotAssociationLexBot = BotAssociationLexBot(
            lexRegion = javaType.lexRegion().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
        )
    }
}
