@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getContactFlowModule.
 * @property arn ARN of the Contact Flow Module.
 * @property contactFlowModuleId
 * @property content Logic of the Contact Flow Module.
 * @property description Description of the Contact Flow Module.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId
 * @property name
 * @property state Type of Contact Flow Module Module. Values are either `ACTIVE` or `ARCHIVED`.
 * @property status Status of the Contact Flow Module Module. Values are either `PUBLISHED` or `SAVED`.
 * @property tags Map of tags to assign to the Contact Flow Module.
 */
public data class GetContactFlowModuleResult(
    public val arn: String,
    public val contactFlowModuleId: String,
    public val content: String,
    public val description: String,
    public val id: String,
    public val instanceId: String,
    public val name: String,
    public val state: String,
    public val status: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetContactFlowModuleResult):
            GetContactFlowModuleResult = GetContactFlowModuleResult(
            arn = javaType.arn(),
            contactFlowModuleId = javaType.contactFlowModuleId(),
            content = javaType.content(),
            description = javaType.description(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            name = javaType.name(),
            state = javaType.state(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
