@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getHoursOfOperation.
 * @property arn ARN of the Hours of Operation.
 * @property configs Configuration information for the hours of operation: day, start time, and end time . Config blocks are documented below. Config blocks are documented below.
 * @property description Description of the Hours of Operation.
 * @property hoursOfOperationId The identifier for the hours of operation.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId Identifier of the hosting Amazon Connect Instance.
 * @property name Name of the Hours of Operation.
 * @property tags Map of tags to assign to the Hours of Operation.
 * @property timeZone Time zone of the Hours of Operation.
 */
public data class GetHoursOfOperationResult(
    public val arn: String,
    public val configs: List<GetHoursOfOperationConfig>,
    public val description: String,
    public val hoursOfOperationId: String,
    public val id: String,
    public val instanceId: String,
    public val name: String,
    public val tags: Map<String, String>,
    public val timeZone: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetHoursOfOperationResult):
            GetHoursOfOperationResult = GetHoursOfOperationResult(
            arn = javaType.arn(),
            configs = javaType.configs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.GetHoursOfOperationConfig.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description(),
            hoursOfOperationId = javaType.hoursOfOperationId(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timeZone = javaType.timeZone(),
        )
    }
}
