@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getInstance.
 * @property arn ARN of the instance.
 * @property autoResolveBestVoicesEnabled
 * @property contactFlowLogsEnabled Whether contact flow logs are enabled.
 * @property contactLensEnabled Whether contact lens is enabled.
 * @property createdTime When the instance was created.
 * @property earlyMediaEnabled Whether early media for outbound calls is enabled .
 * @property id The provider-assigned unique ID for this managed resource.
 * @property identityManagementType Specifies The identity management type attached to the instance.
 * @property inboundCallsEnabled Whether inbound calls are enabled.
 * @property instanceAlias
 * @property instanceId
 * @property multiPartyConferenceEnabled Whether multi-party calls/conference is enabled.
 * @property outboundCallsEnabled Whether outbound calls are enabled.
 * @property serviceRole Service role of the instance.
 * @property status State of the instance.
 */
public data class GetInstanceResult(
    public val arn: String,
    public val autoResolveBestVoicesEnabled: Boolean,
    public val contactFlowLogsEnabled: Boolean,
    public val contactLensEnabled: Boolean,
    public val createdTime: String,
    public val earlyMediaEnabled: Boolean,
    public val id: String,
    public val identityManagementType: String,
    public val inboundCallsEnabled: Boolean,
    public val instanceAlias: String,
    public val instanceId: String,
    public val multiPartyConferenceEnabled: Boolean,
    public val outboundCallsEnabled: Boolean,
    public val serviceRole: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetInstanceResult):
            GetInstanceResult = GetInstanceResult(
            arn = javaType.arn(),
            autoResolveBestVoicesEnabled = javaType.autoResolveBestVoicesEnabled(),
            contactFlowLogsEnabled = javaType.contactFlowLogsEnabled(),
            contactLensEnabled = javaType.contactLensEnabled(),
            createdTime = javaType.createdTime(),
            earlyMediaEnabled = javaType.earlyMediaEnabled(),
            id = javaType.id(),
            identityManagementType = javaType.identityManagementType(),
            inboundCallsEnabled = javaType.inboundCallsEnabled(),
            instanceAlias = javaType.instanceAlias(),
            instanceId = javaType.instanceId(),
            multiPartyConferenceEnabled = javaType.multiPartyConferenceEnabled(),
            outboundCallsEnabled = javaType.outboundCallsEnabled(),
            serviceRole = javaType.serviceRole(),
            status = javaType.status(),
        )
    }
}
