@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getLambdaFunctionAssociation.
 * @property functionArn
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId
 */
public data class GetLambdaFunctionAssociationResult(
    public val functionArn: String,
    public val id: String,
    public val instanceId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetLambdaFunctionAssociationResult):
            GetLambdaFunctionAssociationResult = GetLambdaFunctionAssociationResult(
            functionArn = javaType.functionArn(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
        )
    }
}
