@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property outboundCallerIdName Specifies the caller ID name.
 * @property outboundCallerIdNumberId Specifies the caller ID number.
 * @property outboundFlowId Outbound whisper flow to be used during an outbound call.
 */
public data class GetQueueOutboundCallerConfig(
    public val outboundCallerIdName: String,
    public val outboundCallerIdNumberId: String,
    public val outboundFlowId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetQueueOutboundCallerConfig):
            GetQueueOutboundCallerConfig = GetQueueOutboundCallerConfig(
            outboundCallerIdName = javaType.outboundCallerIdName(),
            outboundCallerIdNumberId = javaType.outboundCallerIdNumberId(),
            outboundFlowId = javaType.outboundFlowId(),
        )
    }
}
