@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property phoneConfigs Phone configuration of the Quick Connect. This is returned only if `quick_connect_type` is `PHONE_NUMBER`. The `phone_config` block is documented below.
 * @property queueConfigs Queue configuration of the Quick Connect. This is returned only if `quick_connect_type` is `QUEUE`. The `queue_config` block is documented below.
 * @property quickConnectType Configuration type of the Quick Connect. Valid values are `PHONE_NUMBER`, `QUEUE`, `USER`.
 * @property userConfigs User configuration of the Quick Connect. This is returned only if `quick_connect_type` is `USER`. The `user_config` block is documented below.
 */
public data class GetQuickConnectQuickConnectConfig(
    public val phoneConfigs: List<GetQuickConnectQuickConnectConfigPhoneConfig>,
    public val queueConfigs: List<GetQuickConnectQuickConnectConfigQueueConfig>,
    public val quickConnectType: String,
    public val userConfigs: List<GetQuickConnectQuickConnectConfigUserConfig>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetQuickConnectQuickConnectConfig):
            GetQuickConnectQuickConnectConfig = GetQuickConnectQuickConnectConfig(
            phoneConfigs = javaType.phoneConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.GetQuickConnectQuickConnectConfigPhoneConfig.Companion.toKotlin(args0)
                })
            }),
            queueConfigs = javaType.queueConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.GetQuickConnectQuickConnectConfigQueueConfig.Companion.toKotlin(args0)
                })
            }),
            quickConnectType = javaType.quickConnectType(),
            userConfigs = javaType.userConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.GetQuickConnectQuickConnectConfigUserConfig.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
