@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property channel Channels agents can handle in the Contact Control Panel (CCP) for this routing profile. Valid values are `VOICE`, `CHAT`, `TASK`.
 * @property concurrency Number of contacts an agent can have on a channel simultaneously. Valid Range for `VOICE`: Minimum value of 1. Maximum value of 1. Valid Range for `CHAT`: Minimum value of 1. Maximum value of 10. Valid Range for `TASK`: Minimum value of 1. Maximum value of 10.
 */
public data class GetRoutingProfileMediaConcurrency(
    public val channel: String,
    public val concurrency: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetRoutingProfileMediaConcurrency):
            GetRoutingProfileMediaConcurrency = GetRoutingProfileMediaConcurrency(
            channel = javaType.channel(),
            concurrency = javaType.concurrency(),
        )
    }
}
