@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getRoutingProfile.
 * @property arn ARN of the Routing Profile.
 * @property defaultOutboundQueueId Specifies the default outbound queue for the Routing Profile.
 * @property description Description of the Routing Profile.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId
 * @property mediaConcurrencies One or more `media_concurrencies` blocks that specify the channels that agents can handle in the Contact Control Panel (CCP) for this Routing Profile. The `media_concurrencies` block is documented below.
 * @property name
 * @property queueConfigs One or more `queue_configs` blocks that specify the inbound queues associated with the routing profile. If no queue is added, the agent only can make outbound calls. The `queue_configs` block is documented below.
 * @property routingProfileId
 * @property tags Map of tags to assign to the Routing Profile.
 */
public data class GetRoutingProfileResult(
    public val arn: String,
    public val defaultOutboundQueueId: String,
    public val description: String,
    public val id: String,
    public val instanceId: String,
    public val mediaConcurrencies: List<GetRoutingProfileMediaConcurrency>,
    public val name: String,
    public val queueConfigs: List<GetRoutingProfileQueueConfig>,
    public val routingProfileId: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetRoutingProfileResult):
            GetRoutingProfileResult = GetRoutingProfileResult(
            arn = javaType.arn(),
            defaultOutboundQueueId = javaType.defaultOutboundQueueId(),
            description = javaType.description(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            mediaConcurrencies = javaType.mediaConcurrencies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.GetRoutingProfileMediaConcurrency.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            queueConfigs = javaType.queueConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.GetRoutingProfileQueueConfig.Companion.toKotlin(args0)
                })
            }),
            routingProfileId = javaType.routingProfileId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
