@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getSecurityProfile.
 * @property arn ARN of the Security Profile.
 * @property description Description of the Security Profile.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId
 * @property name
 * @property organizationResourceId The organization resource identifier for the security profile.
 * @property permissions List of permissions assigned to the security profile.
 * @property securityProfileId
 * @property tags Map of tags to assign to the Security Profile.
 */
public data class GetSecurityProfileResult(
    public val arn: String,
    public val description: String,
    public val id: String,
    public val instanceId: String,
    public val name: String,
    public val organizationResourceId: String,
    public val permissions: List<String>,
    public val securityProfileId: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetSecurityProfileResult):
            GetSecurityProfileResult = GetSecurityProfileResult(
            arn = javaType.arn(),
            description = javaType.description(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            name = javaType.name(),
            organizationResourceId = javaType.organizationResourceId(),
            permissions = javaType.permissions().map({ args0 -> args0 }),
            securityProfileId = javaType.securityProfileId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
