@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getUserHierarchyGroup.
 * @property arn ARN of the hierarchy group.
 * @property hierarchyGroupId
 * @property hierarchyPaths Block that contains information about the levels in the hierarchy group. The `hierarchy_path` block is documented below.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId
 * @property levelId Identifier of the level in the hierarchy group.
 * @property name Name of the hierarchy group.
 * @property tags Map of tags to assign to the hierarchy group.
 */
public data class GetUserHierarchyGroupResult(
    public val arn: String,
    public val hierarchyGroupId: String,
    public val hierarchyPaths: List<GetUserHierarchyGroupHierarchyPath>,
    public val id: String,
    public val instanceId: String,
    public val levelId: String,
    public val name: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetUserHierarchyGroupResult):
            GetUserHierarchyGroupResult = GetUserHierarchyGroupResult(
            arn = javaType.arn(),
            hierarchyGroupId = javaType.hierarchyGroupId(),
            hierarchyPaths = javaType.hierarchyPaths().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.GetUserHierarchyGroupHierarchyPath.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            levelId = javaType.levelId(),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
