@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getUserHierarchyStructure.
 * @property hierarchyStructures Block that defines the hierarchy structure's levels. The `hierarchy_structure` block is documented below.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId
 */
public data class GetUserHierarchyStructureResult(
    public val hierarchyStructures: List<GetUserHierarchyStructureHierarchyStructure>,
    public val id: String,
    public val instanceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.GetUserHierarchyStructureResult):
            GetUserHierarchyStructureResult = GetUserHierarchyStructureResult(
            hierarchyStructures = javaType.hierarchyStructures().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.GetUserHierarchyStructureHierarchyStructure.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
        )
    }
}
