@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property day Specifies the day that the hours of operation applies to.
 * @property endTime A end time block specifies the time that your contact center closes. The `end_time` is documented below.
 * @property startTime A start time block specifies the time that your contact center opens. The `start_time` is documented below.
 */
public data class HoursOfOperationConfig(
    public val day: String,
    public val endTime: HoursOfOperationConfigEndTime,
    public val startTime: HoursOfOperationConfigStartTime,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.HoursOfOperationConfig):
            HoursOfOperationConfig = HoursOfOperationConfig(
            day = javaType.day(),
            endTime = javaType.endTime().let({ args0 ->
                com.pulumi.aws.connect.kotlin.outputs.HoursOfOperationConfigEndTime.Companion.toKotlin(args0)
            }),
            startTime = javaType.startTime().let({ args0 ->
                com.pulumi.aws.connect.kotlin.outputs.HoursOfOperationConfigStartTime.Companion.toKotlin(args0)
            }),
        )
    }
}
