@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName The S3 bucket name.
 * @property bucketPrefix The S3 bucket prefix.
 * @property encryptionConfig The encryption configuration. Documented below.
 */
public data class InstanceStorageConfigStorageConfigS3Config(
    public val bucketName: String,
    public val bucketPrefix: String,
    public val encryptionConfig: InstanceStorageConfigStorageConfigS3ConfigEncryptionConfig? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.connect.outputs.InstanceStorageConfigStorageConfigS3Config):
            InstanceStorageConfigStorageConfigS3Config = InstanceStorageConfigStorageConfigS3Config(
            bucketName = javaType.bucketName(),
            bucketPrefix = javaType.bucketPrefix(),
            encryptionConfig = javaType.encryptionConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.InstanceStorageConfigStorageConfigS3ConfigEncryptionConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
