@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property phoneConfigs Specifies the phone configuration of the Quick Connect. This is required only if `quick_connect_type` is `PHONE_NUMBER`. The `phone_config` block is documented below.
 * @property queueConfigs Specifies the queue configuration of the Quick Connect. This is required only if `quick_connect_type` is `QUEUE`. The `queue_config` block is documented below.
 * @property quickConnectType Specifies the configuration type of the quick connect. valid values are `PHONE_NUMBER`, `QUEUE`, `USER`.
 * @property userConfigs Specifies the user configuration of the Quick Connect. This is required only if `quick_connect_type` is `USER`. The `user_config` block is documented below.
 */
public data class QuickConnectQuickConnectConfig(
    public val phoneConfigs: List<QuickConnectQuickConnectConfigPhoneConfig>? = null,
    public val queueConfigs: List<QuickConnectQuickConnectConfigQueueConfig>? = null,
    public val quickConnectType: String,
    public val userConfigs: List<QuickConnectQuickConnectConfigUserConfig>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.QuickConnectQuickConnectConfig):
            QuickConnectQuickConnectConfig = QuickConnectQuickConnectConfig(
            phoneConfigs = javaType.phoneConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.QuickConnectQuickConnectConfigPhoneConfig.Companion.toKotlin(args0)
                })
            }),
            queueConfigs = javaType.queueConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.QuickConnectQuickConnectConfigQueueConfig.Companion.toKotlin(args0)
                })
            }),
            quickConnectType = javaType.quickConnectType(),
            userConfigs = javaType.userConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.connect.kotlin.outputs.QuickConnectQuickConnectConfigUserConfig.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
