@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property afterContactWorkTimeLimit The After Call Work (ACW) timeout setting, in seconds. Minimum value of 0.
 * @property autoAccept When Auto-Accept Call is enabled for an available agent, the agent connects to contacts automatically.
 * @property deskPhoneNumber The phone number for the user's desk phone. Required if `phone_type` is set as `DESK_PHONE`.
 * @property phoneType The phone type. Valid values are `DESK_PHONE` and `SOFT_PHONE`.
 */
public data class UserPhoneConfig(
    public val afterContactWorkTimeLimit: Int? = null,
    public val autoAccept: Boolean? = null,
    public val deskPhoneNumber: String? = null,
    public val phoneType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.connect.outputs.UserPhoneConfig): UserPhoneConfig =
            UserPhoneConfig(
                afterContactWorkTimeLimit = javaType.afterContactWorkTimeLimit().map({ args0 ->
                    args0
                }).orElse(null),
                autoAccept = javaType.autoAccept().map({ args0 -> args0 }).orElse(null),
                deskPhoneNumber = javaType.deskPhoneNumber().map({ args0 -> args0 }).orElse(null),
                phoneType = javaType.phoneType(),
            )
    }
}
