@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.controltower.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ControlTowerControl].
 */
@PulumiTagMarker
public class ControlTowerControlResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ControlTowerControlArgs = ControlTowerControlArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ControlTowerControlArgsBuilder.() -> Unit) {
        val builder = ControlTowerControlArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ControlTowerControl {
        val builtJavaResource = com.pulumi.aws.controltower.ControlTowerControl(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ControlTowerControl(builtJavaResource)
    }
}

/**
 * Allows the application of pre-defined controls to organizational units. For more information on usage, please see the
 * [AWS Control Tower User Guide](https://docs.aws.amazon.com/controltower/latest/userguide/enable-guardrails.html).
 * ## Example Usage
 * No Java example available.
 * ## Import
 * Using `pulumi import`, import Control Tower Controls using their `organizational_unit_arn/control_identifier`. For example:
 * ```sh
 *  $ pulumi import aws:controltower/controlTowerControl:ControlTowerControl example arn:aws:organizations::123456789101:ou/o-qqaejywet/ou-qg5o-ufbhdtv3,arn:aws:controltower:us-east-1::control/WTDSMKDKDNLE
 * ```
 *
 */
public class ControlTowerControl internal constructor(
    override val javaResource: com.pulumi.aws.controltower.ControlTowerControl,
) : KotlinCustomResource(javaResource, ControlTowerControlMapper) {
    /**
     * The ARN of the control. Only Strongly recommended and Elective controls are permitted, with the exception of the Region deny guardrail.
     */
    public val controlIdentifier: Output<String>
        get() = javaResource.controlIdentifier().applyValue({ args0 -> args0 })

    /**
     * The ARN of the organizational unit.
     */
    public val targetIdentifier: Output<String>
        get() = javaResource.targetIdentifier().applyValue({ args0 -> args0 })
}

public object ControlTowerControlMapper : ResourceMapper<ControlTowerControl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.controltower.ControlTowerControl::class == javaResource::class

    override fun map(javaResource: Resource): ControlTowerControl = ControlTowerControl(
        javaResource
            as com.pulumi.aws.controltower.ControlTowerControl,
    )
}

/**
 * @see [ControlTowerControl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ControlTowerControl].
 */
public suspend fun controlTowerControl(
    name: String,
    block: suspend ControlTowerControlResourceBuilder.() -> Unit,
): ControlTowerControl {
    val builder = ControlTowerControlResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ControlTowerControl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun controlTowerControl(name: String): ControlTowerControl {
    val builder = ControlTowerControlResourceBuilder()
    builder.name(name)
    return builder.build()
}
