@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.controltower.kotlin

import com.pulumi.aws.controltower.ControlTowerControlArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Allows the application of pre-defined controls to organizational units. For more information on usage, please see the
 * [AWS Control Tower User Guide](https://docs.aws.amazon.com/controltower/latest/userguide/enable-guardrails.html).
 * ## Example Usage
 * No Java example available.
 * ## Import
 * Using `pulumi import`, import Control Tower Controls using their `organizational_unit_arn/control_identifier`. For example:
 * ```sh
 *  $ pulumi import aws:controltower/controlTowerControl:ControlTowerControl example arn:aws:organizations::123456789101:ou/o-qqaejywet/ou-qg5o-ufbhdtv3,arn:aws:controltower:us-east-1::control/WTDSMKDKDNLE
 * ```
 * @property controlIdentifier The ARN of the control. Only Strongly recommended and Elective controls are permitted, with the exception of the Region deny guardrail.
 * @property targetIdentifier The ARN of the organizational unit.
 */
public data class ControlTowerControlArgs(
    public val controlIdentifier: Output<String>? = null,
    public val targetIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.controltower.ControlTowerControlArgs> {
    override fun toJava(): com.pulumi.aws.controltower.ControlTowerControlArgs =
        com.pulumi.aws.controltower.ControlTowerControlArgs.builder()
            .controlIdentifier(controlIdentifier?.applyValue({ args0 -> args0 }))
            .targetIdentifier(targetIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ControlTowerControlArgs].
 */
@PulumiTagMarker
public class ControlTowerControlArgsBuilder internal constructor() {
    private var controlIdentifier: Output<String>? = null

    private var targetIdentifier: Output<String>? = null

    /**
     * @param value The ARN of the control. Only Strongly recommended and Elective controls are permitted, with the exception of the Region deny guardrail.
     */
    @JvmName("rketxtfwdusybvkl")
    public suspend fun controlIdentifier(`value`: Output<String>) {
        this.controlIdentifier = value
    }

    /**
     * @param value The ARN of the organizational unit.
     */
    @JvmName("lbraejlddeobywwv")
    public suspend fun targetIdentifier(`value`: Output<String>) {
        this.targetIdentifier = value
    }

    /**
     * @param value The ARN of the control. Only Strongly recommended and Elective controls are permitted, with the exception of the Region deny guardrail.
     */
    @JvmName("kiqsmvymxxvothmf")
    public suspend fun controlIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlIdentifier = mapped
    }

    /**
     * @param value The ARN of the organizational unit.
     */
    @JvmName("ctssydtuaihjfjsf")
    public suspend fun targetIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetIdentifier = mapped
    }

    internal fun build(): ControlTowerControlArgs = ControlTowerControlArgs(
        controlIdentifier = controlIdentifier,
        targetIdentifier = targetIdentifier,
    )
}
