@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.controltower.kotlin

import com.pulumi.aws.controltower.ControltowerFunctions.getControlsPlain
import com.pulumi.aws.controltower.kotlin.inputs.GetControlsPlainArgs
import com.pulumi.aws.controltower.kotlin.inputs.GetControlsPlainArgsBuilder
import com.pulumi.aws.controltower.kotlin.outputs.GetControlsResult
import com.pulumi.aws.controltower.kotlin.outputs.GetControlsResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object ControltowerFunctions {
    /**
     * List of Control Tower controls applied to an OU.
     * ## Example Usage
     * No Java example available.
     * @param argument A collection of arguments for invoking getControls.
     * @return A collection of values returned by getControls.
     */
    public suspend fun getControls(argument: GetControlsPlainArgs): GetControlsResult =
        toKotlin(getControlsPlain(argument.toJava()).await())

    /**
     * @see [getControls].
     * @param targetIdentifier The ARN of the organizational unit.
     * @return A collection of values returned by getControls.
     */
    public suspend fun getControls(targetIdentifier: String): GetControlsResult {
        val argument = GetControlsPlainArgs(
            targetIdentifier = targetIdentifier,
        )
        return toKotlin(getControlsPlain(argument.toJava()).await())
    }

    /**
     * @see [getControls].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;controltower&#46;kotlin&#46;inputs&#46;GetControlsPlainArgs].
     * @return A collection of values returned by getControls.
     */
    public suspend fun getControls(argument: suspend GetControlsPlainArgsBuilder.() -> Unit):
        GetControlsResult {
        val builder = GetControlsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getControlsPlain(builtArgument.toJava()).await())
    }
}
