@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.controltower.kotlin.inputs

import com.pulumi.aws.controltower.inputs.GetControlsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getControls.
 * @property targetIdentifier The ARN of the organizational unit.
 */
public data class GetControlsPlainArgs(
    public val targetIdentifier: String,
) : ConvertibleToJava<com.pulumi.aws.controltower.inputs.GetControlsPlainArgs> {
    override fun toJava(): com.pulumi.aws.controltower.inputs.GetControlsPlainArgs =
        com.pulumi.aws.controltower.inputs.GetControlsPlainArgs.builder()
            .targetIdentifier(targetIdentifier.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetControlsPlainArgs].
 */
@PulumiTagMarker
public class GetControlsPlainArgsBuilder internal constructor() {
    private var targetIdentifier: String? = null

    /**
     * @param value The ARN of the organizational unit.
     */
    @JvmName("iofrxsftkwteqvke")
    public suspend fun targetIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.targetIdentifier = mapped
    }

    internal fun build(): GetControlsPlainArgs = GetControlsPlainArgs(
        targetIdentifier = targetIdentifier ?: throw PulumiNullFieldException("targetIdentifier"),
    )
}
